/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2013-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		åȰ¸⥸塼ʥߡåѡ
 */

#include "kernel_impl.h"
#include "task.h"

/*
 *  ȥ졼ޥΥǥե
 */
#ifndef LOG_DSP_ENTER
#define LOG_DSP_ENTER(p_tcb)
#endif /* LOG_DSP_ENTER */

#ifndef LOG_DSP_LEAVE
#define LOG_DSP_LEAVE(p_tcb)
#endif /* LOG_DSP_LEAVE */

/*
 *  ǥѥå
 */
static void
dispatcher(void)
{
	LOG_DSP_ENTER(p_runtsk);
	while ((p_runtsk = p_schedtsk) == NULL) {
		/* ߤĤCPUå֤ˤʤ褦 */
		/* 󥿥ƥȤڤ괹 */
		do {
			/* ߤ򤹤٤ƵĤȯԤ */
			/* ߵξ֤᤹ʡᥫͥγߤػߤ*/
		} while (!reqflg);
		reqflg = false;
		/* ƥȤ᤹ */
		/* CPUå֤᤹ */
	}
	/* p_runtskˤTCB饹åݥ󥿤 */
	LOG_DSP_LEAVE(p_runtsk);
	/* TCB¹ԺƳϤʬ */
}

/*
 *  ǹ̥ͥؤΥǥѥå
 */
void
dispatch(void)
{
#ifdef TOPPERS_SUPPORT_OVRHDR
	ovrtimer_stop();					/* Х󥿥ޤ */
#endif /* TOPPERS_SUPPORT_OVRHDR */
	/* å쥸٤ƤΥ쥸򥹥å¸ */
	/* åݥ󥿤򼫥p_runtskˤTCB¸ */
	/* dispatch_r򡤼¹ԺƳϤȤƼTCB¸ */
	dispatcher();

/* dispatch_r: */
	/* å쥸٤ƤΥ쥸򥹥å */
#ifdef TOPPERS_SUPPORT_OVRHDR
	ovrtimer_start();					/* Х󥿥ޤư */
#endif /* TOPPERS_SUPPORT_OVRHDR */
	calltex();
}

/*
 *  ǥѥåư
 */
void
start_dispatch(void)
{
	/* ƥȤڤ괹 */
	/* CPUå֡ͥ٥ޥ֤ˤ */
	/* dispatcher_0ʬ */
}

/*
 *  ߤΥƥȤΤƤƥǥѥå
 */
void
exit_and_dispatch(void)
{
	/* dispatcherʬ */
}

/*
 *  ߥϥɥи
 *
 *  ߥϥɥǤϡͥγߤػߤƤ뤿ᡤи
 *  ǳߤػߤɬפϤʤ
 */
void
ret_int(void)
{
}

/*
 *  CPU㳰ϥɥи
 */
void
ret_exc(void)
{
}

/*
 *  ͥνλθƽФ
 */
void
call_exit_kernel(void)
{
	/* 󥿥ƥȤڤ괹 */
	/* exit_kernelʬ */
	while (true);
}

/*
 *  ϻ
 */
void
start_r(void)
{
#ifdef TOPPERS_SUPPORT_OVRHDR
	ovrtimer_start();					/* Х󥿥ޤư */
#endif /* TOPPERS_SUPPORT_OVRHDR */
	/* CPUå֤ˤ */
	/* p_runtskˤεưϤ򡤳ĥѥ᡼ȤƸƤӽФ */
	/* ext_tskʬ */
}

/*
 *  åȰ¸ν
 */
void
target_initialize(void)
{
}

/*
 *  åȰ¸νλ
 */
void
target_exit(void)
{
	exit(0);
}

/*
 *  ƥ٥ϤΤʸ
 */
void
target_fput_log(char c)
{
	/* ʸcɽ//¸ */
}

/*
 *  ᥤؿ
 */
int
main()
{
	sta_ker();
	return(0);
}

/*
 *  ͥγդΰδ
 *
 *  TLSFʥץ󥽡Υ饤֥ˤѤƼ¸
 */
#ifdef TOPPERS_SUPPORT_DYNAMIC_CRE

#include "tlsf.h"

static bool_t	tlsf_initialized = false;

void
initialize_kmm(void)
{
	if (init_memory_pool(kmmsz, kmm) >= 0) {
		tlsf_initialized = true;
	}
}

void *
kernel_malloc(SIZE size)
{
	if (tlsf_initialized) {
		return(malloc_ex(size, kmm));
	}
	else {
		return(NULL);
	}
}

void
kernel_free(void *ptr)
{
	if (tlsf_initialized) {
		free_ex(ptr, kmm);
	}
}

#endif /* TOPPERS_SUPPORT_DYNAMIC_CRE */
