/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		Ĺס뵡ǽ
 */

#ifndef TOPPERS_MEMPFIX_H
#define TOPPERS_MEMPFIX_H

#include "wait.h"

/*
 *  Ĺ֥å֥å
 *
 *  nextեɤˤϡ֥åƺѤߤξINDEX_ALLOC
 *  ̤Ƥξϼ̤ƥ֥åΥǥåֹǼ롥
 *  Ǹ̤ƥ֥åξˤϡINDEX_NULLǼ롥
 */
typedef struct fixed_memoryblock_management_block {
	uint_t		next;			/* ̤ƥ֥å */
} MPFMB;

/*
 *  Ĺס֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥν֥åζʬ
 *  WOBJINIBˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽΥեɤ̤ˤʤäƤ롥
 */
typedef struct fixed_memorypool_initialization_block {
	ATR			mpfatr;			/* Ĺס° */
	uint_t		blkcnt;			/* ֥å */
	uint_t		blksz;			/* ֥åΥʴݤ᤿͡ */
	void		*mpf;			/* ĹסΰƬ */
	MPFMB		*p_mpfmb;		/* ĹסΰƬ */
} MPFINIB;

/*
 *  Ĺס֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥδ֥åζʬWOBJCB
 *  ĥʥ֥ȻظηѾˤΤǡǽ2Ĥ
 *  եɤ̤ˤʤäƤ롥
 */
typedef struct fixed_memorypool_control_block {
	QUEUE		wait_queue;		/* ĹסԤ塼 */
	const MPFINIB *p_mpfinib;	/* ֥åؤΥݥ */
	uint_t		fblkcnt;		/* ̤ƥ֥å */
	uint_t		unused;			/* ̤ѥ֥åƬ */
	uint_t		freelist;		/* ̤ƥ֥åΥꥹ */
} MPFCB;

/*
 *  ĹסԤ֥å
 *
 *  ι¤ΤϡƱ֥̿ȤԤ֥åζʬ
 *  WINFO_WOBJˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽ2ĤΥեɤ̤ˤʤäƤ롥
 */
typedef struct fixed_memorypool_waiting_information {
	WINFO		winfo;			/* ɸԤ֥å */
	MPFCB		*p_mpfcb;		/* ԤäƤĹסδ֥å*/
	void		*blk;			/* ֥å */
} WINFO_MPF;

/*
 *  ĹסIDκ͡kernel_cfg.c
 */
extern const ID	tmax_mpfid;

/*
 *  Ĺס֥åΥꥢkernel_cfg.c
 */
extern const MPFINIB	mpfinib_table[];

/*
 *  Ĺס֥åΥꥢkernel_cfg.c
 */
extern MPFCB	mpfcb_table[];

/*
 *  Ĺס֥åĹסIDФ
 *  Υޥ
 */
#define	MPFID(p_mpfcb)	((ID)(((p_mpfcb) - mpfcb_table) + TMIN_MPFID))

/*
 *  Ĺס뵡ǽν
 */
extern void	initialize_mempfix(void);

/*
 *  Ĺס뤫֥å
 */
extern void	get_mpf_block(MPFCB *p_mpfcb, void **p_blk);

#endif /* TOPPERS_MEMPFIX_H */
