/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ǡ塼ǽ
 */

#ifndef TOPPERS_DATAQUEUE_H
#define TOPPERS_DATAQUEUE_H

#include "wait.h"

/*
 *  ǡ֥å
 */
typedef struct data_management_block {
	intptr_t	data;			/* ǡ */
} DTQMB;

/*
 *  ǡ塼֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥν֥åζʬ
 *  WOBJINIBˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽΥեɤ̤ˤʤäƤ롥
 */
typedef struct dataqueue_initialization_block {
	ATR			dtqatr;			/* ǡ塼° */
	uint_t		dtqcnt;			/* ǡ塼 */
	DTQMB		*p_dtqmb;		/* ǡ塼ΰƬ */
} DTQINIB;

/*
 *  ǡ塼֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥδ֥åζʬWOBJCB
 *  ĥʥ֥ȻظηѾˤΤǡǽ2Ĥ
 *  եɤ̤ˤʤäƤ롥
 */
typedef struct dataqueue_control_block {
	QUEUE		swait_queue;	/* ǡ塼Ԥ塼 */
	const DTQINIB *p_dtqinib;	/* ֥åؤΥݥ */
	QUEUE		rwait_queue;	/* ǡ塼Ԥ塼 */
	uint_t		count;			/* ǡ塼Υǡο */
	uint_t		head;			/* ǽΥǡγǼ */
	uint_t		tail;			/* ǸΥǡγǼμ */
} DTQCB;

/*
 *  ǡ塼Ԥ֥å
 *
 *  ι¤ΤϡƱ֥̿ȤԤ֥åζʬ
 *  WINFO_WOBJˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽ2ĤΥեɤ̤ˤʤäƤ롥
 *  ǡ塼ؤԤȥǡ塼μԤǡƱԤ
 *  ֥åȤ
 */
typedef struct dataqueue_waiting_information {
	WINFO		winfo;			/* ɸԤ֥å */
	DTQCB		*p_dtqcb;		/* ԤäƤǡ塼δ֥å */
	intptr_t	data;			/* ǡ */
} WINFO_DTQ;

/*
 *  ǡ塼IDκ͡kernel_cfg.c
 */
extern const ID	tmax_dtqid;

/*
 *  ǡ塼֥åΥꥢkernel_cfg.c
 */
extern const DTQINIB	dtqinib_table[];

/*
 *  ǡ塼֥åΥꥢkernel_cfg.c
 */
extern DTQCB	dtqcb_table[];

/*
 *  ǡ塼֥åǡ塼IDФΥޥ
 */
#define	DTQID(p_dtqcb)	((ID)(((p_dtqcb) - dtqcb_table) + TMIN_DTQID))

/*
 *  ǡ塼ǽν
 */
extern void	initialize_dataqueue(void);

/*
 *  ǡ塼ΰؤΥǡγǼ
 */
extern void	enqueue_data(DTQCB *p_dtqcb, intptr_t data);

/*
 *  ǡ塼ΰؤΥǡζǼ
 */
extern void	force_enqueue_data(DTQCB *p_dtqcb, intptr_t data);

/*
 *  ǡ塼ΰ褫ΥǡμФ
 */
extern void	dequeue_data(DTQCB *p_dtqcb, intptr_t *p_data);

/*
 *  ǡ塼ؤΥǡ
 */
extern bool_t	send_data(DTQCB *p_dtqcb, intptr_t data, bool_t *p_dspreq);

/*
 *  ǡ塼ؤΥǡ
 */
extern bool_t	force_send_data(DTQCB *p_dtqcb, intptr_t data);

/*
 *  ǡ塼Υǡ
 */
extern bool_t	receive_data(DTQCB *p_dtqcb, intptr_t *p_data,
													bool_t *p_dspreq);

#endif /* TOPPERS_DATAQUEUE_H */
