/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ƥϤԤ
 *
 *  ƥӥϡƥΥϤ뤿Υӥ
 *  Ǥ롥ͥ뤫ΥνϤˤѤ뤿ᡤԤ
 *  ˤϤ뤳ȤϤʤ
 *
 *  ϡͥΥХåե˽񤭹फ٥ʸ
 *  ϴؿѤƽϤ롥ɤȤϡĥӥڤ
 *  뤳ȤǤ롥
 *
 *  Хåեΰ褬ХեˤϡŤäƾ
 *  񤭤롥
 *
 *  ֥Υե뤫餳Υե򥤥󥯥롼ɤ
 *  ϡTOPPERS_MACRO_ONLYƤȤǡޥʳεҤ
 *  ȤǤ롥
 *
 *  Υե򥤥󥯥롼ɤˡt_stddef.h򥤥󥯥롼ɤƤ
 *  ȤɬפǤ롥
 */

#ifndef TOPPERS_T_SYSLOG_H
#define TOPPERS_T_SYSLOG_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  μ̤
 */
#define LOG_TYPE_COMMENT	UINT_C(0x01)	/*  */
#define LOG_TYPE_ASSERT		UINT_C(0x02)	/* μ */

#define LOG_TYPE_INH		UINT_C(0x11)	/* ߥϥɥ */
#define LOG_TYPE_ISR		UINT_C(0x12)	/* ߥӥ롼 */
#define LOG_TYPE_CYC		UINT_C(0x13)	/* ϥɥ */
#define LOG_TYPE_ALM		UINT_C(0x14)	/* 顼ϥɥ */
#define LOG_TYPE_OVR		UINT_C(0x15)	/* Хϥɥ */
#define LOG_TYPE_EXC		UINT_C(0x16)	/* CPU㳰ϥɥ */
#define LOG_TYPE_TEX		UINT_C(0x17)	/* 㳰롼 */
#define LOG_TYPE_TSKSTAT	UINT_C(0x18)	/* Ѳ */
#define LOG_TYPE_DSP		UINT_C(0x19)	/* ǥѥå */
#define LOG_TYPE_SVC		UINT_C(0x1a)	/* ӥ */

#define LOG_ENTER			UINT_C(0x00)	/*  */
#define LOG_LEAVE			UINT_C(0x80)	/* иλ */

/*
 *  ν٤
 */
#define LOG_EMERG			UINT_C(0)		/* åȥͤ륨顼 */
#define LOG_ALERT			UINT_C(1)
#define LOG_CRIT			UINT_C(2)
#define LOG_ERROR			UINT_C(3)		/* ƥ२顼 */
#define LOG_WARNING			UINT_C(4)		/* ٹå */
#define LOG_NOTICE			UINT_C(5)
#define LOG_INFO			UINT_C(6)
#define LOG_DEBUG			UINT_C(7)		/* ǥХåѥå */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  Υǡ¤
 */

#define TMAX_LOGINFO	6

typedef struct {
	uint_t		logtype;				/* μ */
	SYSTIM		logtim;					/*  */
	intptr_t	loginfo[TMAX_LOGINFO];	/* ¾Υ */
} SYSLOG;

/*
 *  ν٤Υӥåȥޥåפ뤿Υޥ
 */
#define LOG_MASK(prio)		(1U << (prio))
#define LOG_UPTO(prio)		((1U << ((prio) + 1)) - 1)

/*
 *  ѥåȷ
 */
typedef struct t_syslog_rlog {
	uint_t	count;		/* ХåեΥο */
	uint_t	lost;		/* 줿ο */
	uint_t	logmask;	/* Хåե˵Ͽ٤ */
	uint_t	lowmask;	/* ٥Ϥ٤ */
} T_SYSLOG_RLOG;

/*
 *  Ϥ뤿Υ饤֥ؿ
 */

#ifndef TOPPERS_OMIT_SYSLOG

extern ER	syslog_wri_log(uint_t prio, const SYSLOG *p_syslog) throw();

Inline void
_syslog_0(uint_t prio, uint_t type)
{
	SYSLOG	logbuf;

	logbuf.logtype = type;
	(void) syslog_wri_log(prio, &logbuf);
}

Inline void
_syslog_1(uint_t prio, uint_t type, intptr_t arg1)
{
	SYSLOG	logbuf;

	logbuf.logtype = type;
	logbuf.loginfo[0] = arg1;
	(void) syslog_wri_log(prio, &logbuf);
}

Inline void
_syslog_2(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2)
{
	SYSLOG	logbuf;

	logbuf.logtype = type;
	logbuf.loginfo[0] = arg1;
	logbuf.loginfo[1] = arg2;
	(void) syslog_wri_log(prio, &logbuf);
}

Inline void
_syslog_3(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2,
														intptr_t arg3)
{
	SYSLOG	logbuf;

	logbuf.logtype = type;
	logbuf.loginfo[0] = arg1;
	logbuf.loginfo[1] = arg2;
	logbuf.loginfo[2] = arg3;
	(void) syslog_wri_log(prio, &logbuf);
}

Inline void
_syslog_4(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2,
										intptr_t arg3, intptr_t arg4)
{
	SYSLOG	logbuf;

	logbuf.logtype = type;
	logbuf.loginfo[0] = arg1;
	logbuf.loginfo[1] = arg2;
	logbuf.loginfo[2] = arg3;
	logbuf.loginfo[3] = arg4;
	(void) syslog_wri_log(prio, &logbuf);
}

Inline void
_syslog_5(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2,
							intptr_t arg3, intptr_t arg4, intptr_t arg5)
{
	SYSLOG	logbuf;

	logbuf.logtype = type;
	logbuf.loginfo[0] = arg1;
	logbuf.loginfo[1] = arg2;
	logbuf.loginfo[2] = arg3;
	logbuf.loginfo[3] = arg4;
	logbuf.loginfo[4] = arg5;
	(void) syslog_wri_log(prio, &logbuf);
}

Inline void
_syslog_6(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2,
				intptr_t arg3, intptr_t arg4, intptr_t arg5, intptr_t arg6)
{
	SYSLOG	logbuf;

	logbuf.logtype = type;
	logbuf.loginfo[0] = arg1;
	logbuf.loginfo[1] = arg2;
	logbuf.loginfo[2] = arg3;
	logbuf.loginfo[3] = arg4;
	logbuf.loginfo[4] = arg5;
	logbuf.loginfo[5] = arg6;
	(void) syslog_wri_log(prio, &logbuf);
}

/*
 *  ʥȡˤϤ뤿Υ饤֥ؿvasyslog.c
 */
extern void	syslog(uint_t prio, const char *format, ...) throw();

#else /* TOPPERS_OMIT_SYSLOG */

/*
 *  ƥϤ޻ߤ
 */

Inline void
_syslog_0(uint_t prio, uint_t type)
{
}

Inline void
_syslog_1(uint_t prio, uint_t type, intptr_t arg1)
{
}

Inline void
_syslog_2(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2)
{
}

Inline void
_syslog_3(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2,
														intptr_t arg3)
{
}

Inline void
_syslog_4(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2,
										intptr_t arg3, intptr_t arg4)
{
}

Inline void
_syslog_5(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2,
							intptr_t arg3, intptr_t arg4, intptr_t arg5)
{
}

Inline void
_syslog_6(uint_t prio, uint_t type, intptr_t arg1, intptr_t arg2,
				intptr_t arg3, intptr_t arg4, intptr_t arg5, intptr_t arg6)
{
}

Inline void
syslog(uint_t prio, const char *format, ...)
{
}

#endif /* TOPPERS_OMIT_SYSLOG */

/*
 *  ʥȡˤϤ뤿Υޥ
 *
 *  formatӸ³ΰå򡤽prioǥ
 *  ȤƽϤ뤿Υޥarg1argnintptr_t˥㥹Ȥ
 *  ᡤintptr_t˷ѴǤǤդηǤ褤
 */

#define syslog_0(prio, format) \
				_syslog_1(prio, LOG_TYPE_COMMENT, (intptr_t)(format))

#define syslog_1(prio, format, arg1) \
				_syslog_2(prio, LOG_TYPE_COMMENT, (intptr_t)(format), \
														(intptr_t)(arg1))

#define syslog_2(prio, format, arg1, arg2) \
				_syslog_3(prio, LOG_TYPE_COMMENT, (intptr_t)(format), \
										(intptr_t)(arg1), (intptr_t)(arg2))

#define syslog_3(prio, format, arg1, arg2, arg3) \
				_syslog_4(prio, LOG_TYPE_COMMENT, (intptr_t)(format), \
						(intptr_t)(arg1), (intptr_t)(arg2), (intptr_t)(arg3))

#define syslog_4(prio, format, arg1, arg2, arg3, arg4) \
				_syslog_5(prio, LOG_TYPE_COMMENT, (intptr_t)(format), \
						(intptr_t)(arg1), (intptr_t)(arg2), (intptr_t)(arg3), \
														(intptr_t)(arg4))

#define syslog_5(prio, format, arg1, arg2, arg3, arg4, arg5) \
				_syslog_6(prio, LOG_TYPE_COMMENT, (intptr_t)(format), \
						(intptr_t)(arg1), (intptr_t)(arg2), (intptr_t)(arg3), \
										(intptr_t)(arg4), (intptr_t)(arg5))

/*
 *  ʥμԡˤϤ뤿Υޥ
 */
#ifndef TOPPERS_assert_fail
#define TOPPERS_assert_fail(exp, file, line) \
				_syslog_3(LOG_EMERG, LOG_TYPE_ASSERT, (intptr_t)(file), \
										(intptr_t)(line), (intptr_t)(exp))
#endif /* TOPPERS_assert_fail */

#endif /* TOPPERS_MACRO_ONLY */

#ifdef __cplusplus
}
#endif

#endif /* TOPPERS_T_SYSLOG_H */
