/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2011 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		⥸塼
 */

#include "kernel_impl.h"
#include "wait.h"
#include "task.h"

/*
 *  ȥ졼ޥΥǥե
 */
#ifndef LOG_TEX_ENTER
#define LOG_TEX_ENTER(p_tcb, texptn)
#endif /* LOG_TEX_ENTER */

#ifndef LOG_TEX_LEAVE
#define LOG_TEX_LEAVE(p_tcb)
#endif /* LOG_TEX_LEAVE */

#ifdef TOPPERS_tskini

/*
 *  ¹Ծ֤Υ
 */
TCB		*p_runtsk;

/*
 *  ǹ̤ͥΥ
 */
TCB		*p_schedtsk;

/*
 *  ǥѥå㳰롼ư׵ե饰
 */
bool_t	reqflg;

/*
 *  ͥ٥ޥ
 */
bool_t	ipmflg;

/*
 *  ǥѥåػ߾
 */
bool_t	disdsp;

/*
 *  ǥѥåǽ
 */
bool_t	dspflg;

/*
 *  ǥ塼
 */
QUEUE	ready_queue[TNUM_TPRI];

/*
 *  ǥ塼ΤΥӥåȥޥå
 */
#ifdef PRIMAP_LEVEL_1
uint16_t	ready_primap;
#else /* PRIMAP_LEVEL_1 */
uint16_t	ready_primap1;
uint16_t	ready_primap2[TNUM_PRIMAP2];
#endif /* PRIMAP_LEVEL_1 */

/*
 *  ⥸塼ν
 */
void
initialize_task(void)
{
	uint_t	i, j;
	TCB		*p_tcb;

	p_runtsk = NULL;
	p_schedtsk = NULL;
	reqflg = false;
	ipmflg = true;
	disdsp = false;
	dspflg = true;

	for (i = 0; i < TNUM_TPRI; i++) {
		queue_initialize(&(ready_queue[i]));
	}
#ifdef PRIMAP_LEVEL_1
	ready_primap = 0U;
#else /* PRIMAP_LEVEL_1 */
	ready_primap1 = 0U;
	for (i = 0; i < TNUM_PRIMAP2; i++) {
		ready_primap2[i] = 0U;
	}
#endif /* PRIMAP_LEVEL_1 */

	for (i = 0; i < tnum_tsk; i++) {
		j = INDEX_TSK(torder_table[i]);
		p_tcb = &(tcb_table[j]);
		p_tcb->p_tinib = &(tinib_table[j]);
		p_tcb->actque = false;
		make_dormant(p_tcb);
		if ((p_tcb->p_tinib->tskatr & TA_ACT) != 0U) {
			(void) make_active(p_tcb);
		}
	}
}

#endif /* TOPPERS_tskini */

/*
 *  ӥåȥޥåץؿ
 *
 *  bitmap1ΥӥåȤ⡤ǤⲼ̡ʱˤΤΤ򥵡Υӥ
 *  ֹ֤ӥåֹϡǲ̥ӥåȤ0Ȥ롥bitmap0
 *  ƤϤʤʤδؿǤϡbitmap16ӥåȤǤ뤳Ȥꤷ
 *  uint16_tȤƤ롥
 *
 *  ӥåȥ̿ĥץåǤϡӥåȥ̿Ȥ褦
 *  ľΨɤ礬롥Τ褦ʾˤϡå
 *  ¸ǥӥåȥ̿Ȥäbitmap_search
 *  OMIT_BITMAP_SEARCHޥФ褤ޤӥåȥ̿
 *  դʤɤͳͥ٤ȥӥåȤȤбѹ
 *  ϡPRIMAP_BITޥФ褤
 *
 *  ޤ饤֥ffsʤ顤Τ褦ƥ饤֥ؿ
 *  ȤäΨɤǽ⤢롥
 *		#define	bitmap_search(bitmap) (ffs(bitmap) - 1)
 */
#ifndef PRIMAP_BIT
#define	PRIMAP_BIT(pri)		(1U << (pri))
#endif /* PRIMAP_BIT */

#ifndef OMIT_BITMAP_SEARCH

static const unsigned char bitmap_search_table[] = { 0, 1, 0, 2, 0, 1, 0,
												3, 0, 1, 0, 2, 0, 1, 0 };

Inline uint_t
bitmap_search(uint16_t bitmap)
{
	uint_t	n = 0U;

	assert(bitmap != 0U);
	if ((bitmap & 0x00ffU) == 0U) {
		bitmap >>= 8;
		n += 8;
	}
	if ((bitmap & 0x0fU) == 0U) {
		bitmap >>= 4;
		n += 4;
	}
	return(n + bitmap_search_table[(bitmap & 0x0fU) - 1]);
}

#endif /* OMIT_BITMAP_SEARCH */

/*
 *  ͥ٥ӥåȥޥåפΥå
 */
Inline bool_t
primap_empty(void)
{
#ifdef PRIMAP_LEVEL_1
	return(ready_primap == 0U);
#else /* PRIMAP_LEVEL_1 */
	return(ready_primap1 == 0U);
#endif /* PRIMAP_LEVEL_1 */
}

/*
 *  ͥ٥ӥåȥޥåפΥ
 */
Inline uint_t
primap_search(void)
{
#ifdef PRIMAP_LEVEL_1
	return(bitmap_search(ready_primap));
#else /* PRIMAP_LEVEL_1 */
	uint_t	i;

	i = bitmap_search(ready_primap1);
	return(i * TBIT_PRIMAP + bitmap_search(ready_primap2[i]));
#endif /* PRIMAP_LEVEL_1 */
}

/*
 *  ͥ٥ӥåȥޥåפΥå
 */
Inline void
primap_set(uint_t pri)
{
#ifdef PRIMAP_LEVEL_1
	ready_primap |= PRIMAP_BIT(pri);
#else /* PRIMAP_LEVEL_1 */
	ready_primap2[pri / TBIT_PRIMAP] |= PRIMAP_BIT(pri % TBIT_PRIMAP);
	ready_primap1 |= PRIMAP_BIT(pri / TBIT_PRIMAP);
#endif /* PRIMAP_LEVEL_1 */
}

/*
 *  ͥ٥ӥåȥޥåפΥꥢ
 */
Inline void
primap_clear(uint_t pri)
{
#ifdef PRIMAP_LEVEL_1
	ready_primap &= ~PRIMAP_BIT(pri);
#else /* PRIMAP_LEVEL_1 */
	if ((ready_primap2[pri / TBIT_PRIMAP] &= ~PRIMAP_BIT(pri % TBIT_PRIMAP))
																	== 0U) {
		ready_primap1 &= ~PRIMAP_BIT(pri / TBIT_PRIMAP);
	}
#endif /* PRIMAP_LEVEL_1 */
}

/*
 *  ǹ̥ͥΥ
 */
#ifdef TOPPERS_tsksched

TCB *
search_schedtsk(void)
{
	uint_t	schedpri;

	schedpri = primap_search();
	return((TCB *)(ready_queue[schedpri].p_next));
}

#endif /* TOPPERS_tsksched */

/*
 *  ¹ԤǤ֤ؤ
 *
 *  ǹ̤ͥΥ򹹿Τϡ¹ԤǤ륿ʤä
 *  ȡp_tcbͥ٤ǹ̤ͥΥͥ٤⤤Ǥ
 *  롥
 */
#ifdef TOPPERS_tskrun

bool_t
make_runnable(TCB *p_tcb)
{
	uint_t	pri = p_tcb->priority;

	queue_insert_prev(&(ready_queue[pri]), &(p_tcb->task_queue));
	primap_set(pri);

	if (p_schedtsk == (TCB *) NULL || pri < p_schedtsk->priority) {
		p_schedtsk = p_tcb;
		return(dspflg);
	}
	return(false);
}

#endif /* TOPPERS_tskrun */

/*
 *  ¹ԤǤ֤¾ξ֤ؤ
 *
 *  ǹ̤ͥΥ򹹿Τϡp_tcbǹ̤ͥΥ
 *  äǤ롥p_tcbƱͥ٤Υ¾ˤϡp_tcb
 *  μΥǹ̤ͥˤʤ롥Ǥʤϡǥ塼
 *  ɬפ롥
 */
#ifdef TOPPERS_tsknrun

bool_t
make_non_runnable(TCB *p_tcb)
{
	uint_t	pri = p_tcb->priority;
	QUEUE	*p_queue = &(ready_queue[pri]);

	queue_delete(&(p_tcb->task_queue));
	if (queue_empty(p_queue)) {
		primap_clear(pri);
		if (p_schedtsk == p_tcb) {
			p_schedtsk = primap_empty() ? (TCB *) NULL : search_schedtsk();
			return(dspflg);
		}
	}
	else {
		if (p_schedtsk == p_tcb) {
			p_schedtsk = (TCB *)(p_queue->p_next);
			return(dspflg);
		}
	}
	return(false);
}

#endif /* TOPPERS_tsknrun */

/*
 *  ٻ߾֤ؤ
 */
#ifdef TOPPERS_tskdmt

void
make_dormant(TCB *p_tcb)
{
	p_tcb->tstat = TS_DORMANT;
	p_tcb->priority = p_tcb->p_tinib->ipriority;
	p_tcb->wupque = false;
	p_tcb->enatex = false;
	p_tcb->texptn = 0U;
	LOG_TSKSTAT(p_tcb);
}

#endif /* TOPPERS_tskdmt */

/*
 *  ٻ߾֤¹ԤǤ֤ؤ
 */
#ifdef TOPPERS_tskact

bool_t
make_active(TCB *p_tcb)
{
	activate_context(p_tcb);
	p_tcb->tstat = TS_RUNNABLE;
	LOG_TSKSTAT(p_tcb);
	return(make_runnable(p_tcb));
}

#endif /* TOPPERS_tskact */

/*
 *  ͥ٤ѹ
 *
 *  ¹ԤǤ֤ξˤϡǥ塼Ǥΰ֤ѹ
 *  롥֥ȤԤ塼Ԥ֤ˤʤäƤˤϡ
 *  塼Ǥΰ֤ѹ롥
 *
 *  ǹ̤ͥΥ򹹿Τϡ(1) p_tcbǹ̤ͥΥ
 *  Ǥäơͥ٤򲼤硤(2) p_tcbǹ̤ͥΥ
 *  ǤϤʤѹͥ٤ǹ̤ͥΥͥ٤⤤
 *  Ǥ롥(1)ξˤϡǥ塼򥵡ɬפ롥
 */
#ifdef TOPPERS_tskpri

bool_t
change_priority(TCB *p_tcb, uint_t newpri)
{
	uint_t	oldpri;

	oldpri = p_tcb->priority;
	p_tcb->priority = newpri;

	if (TSTAT_RUNNABLE(p_tcb->tstat)) {
		/*
		 *  ¹ԤǤ֤ξ
		 */
		queue_delete(&(p_tcb->task_queue));
		if (queue_empty(&(ready_queue[oldpri]))) {
			primap_clear(oldpri);
		}
		queue_insert_prev(&(ready_queue[newpri]), &(p_tcb->task_queue));
		primap_set(newpri);

		if (p_schedtsk == p_tcb) {
			if (newpri >= oldpri) {
				p_schedtsk = search_schedtsk();
				return(p_schedtsk != p_tcb && dspflg);
			}
		}
		else {
			if (newpri < p_schedtsk->priority) {
				p_schedtsk = p_tcb;
				return(dspflg);
			}
		}
	}
	else {
		if (TSTAT_WAIT_WOBJCB(p_tcb->tstat)) {
			/*
			 *  Ʊ֥̿Ȥδ֥åζ
			 *  ʬWOBJCBˤԤ塼ˤĤʤƤ
			 */
			wobj_change_priority(((WINFO_WOBJ *)(p_tcb->p_winfo))->p_wobjcb,
																	p_tcb);
		}
	}
	return(false);
}

#endif /* TOPPERS_tskpri */

/*
 *  ǥ塼βž
 *
 *  ǹ̤ͥΥ򹹿Τϡǹ̤ͥΥ
 *  塼˰ưǤ롥
 */
#ifdef TOPPERS_tskrot

bool_t
rotate_ready_queue(uint_t pri)
{
	QUEUE	*p_queue = &(ready_queue[pri]);
	QUEUE	*p_entry;

	if (!queue_empty(p_queue) && p_queue->p_next->p_next != p_queue) {
		p_entry = queue_delete_next(p_queue);
		queue_insert_prev(p_queue, p_entry);
		if (p_schedtsk == (TCB *) p_entry) {
			p_schedtsk = (TCB *)(p_queue->p_next);
			return(dspflg);
		}
	}
	return(false);
}

#endif /* TOPPERS_tskrot */

/*
 *  㳰롼θƽФ
 *
 *  ASPͥǤϡ㳰롼CPUå֤ܤ
 *  ξ֤ᤵ˥꥿󤷤硤ͥ뤬ξ֤᤹
 */
#ifdef TOPPERS_tsktex

void
call_texrtn(void)
{
	TEXPTN	texptn;
	bool_t	saved_disdsp;

	saved_disdsp = disdsp;
	p_runtsk->enatex = false;
	do {
		texptn = p_runtsk->texptn;
		p_runtsk->texptn = 0U;

		t_unlock_cpu();
		LOG_TEX_ENTER(p_runtsk, texptn);
		(*((TEXRTN)(p_runtsk->p_tinib->texrtn)))(texptn,
												p_runtsk->p_tinib->exinf);
		LOG_TEX_LEAVE(p_runtsk);
		if (!t_sense_lock()) {
			t_lock_cpu();
		}
		if (!ipmflg) {
			t_set_ipm(TIPM_ENAALL);
			ipmflg = true;
		}
		disdsp = saved_disdsp;
		dspflg = !disdsp;
		p_runtsk->enatex = false;
		if (p_runtsk != p_schedtsk && dspflg) {
			/*
			 *  dispatchƤӽФϡߺƵƽФˤʤä
			 *  뤬dispatchƤp_runtsk->enatexfalseˤ
			 *  лپ㤬ʤͳˤĤƤϡTOPPERS/ASP 
			 *  ͥ ߷ץפ򻲾ȤΤȡ
			 */
			dispatch();
		}
	} while (p_runtsk->texptn != 0U);
	p_runtsk->enatex = true;
}

/*
 *  㳰롼εư
 */
#ifndef OMIT_CALLTEX

void
calltex(void)
{
	if (p_runtsk->enatex && p_runtsk->texptn != 0U && ipmflg) {
		call_texrtn();
	}
}

#endif /* OMIT_CALLTEX */
#endif /* TOPPERS_tsktex */
