/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		Хϥɥ鵡ǽ
 */

#ifndef TOPPERS_OVERRUN_H
#define TOPPERS_OVERRUN_H

#ifdef TOPPERS_SUPPORT_OVRHDR
#include "target_timer.h"

/*
 *  Хϥɥ֥å
 */
typedef struct overrun_handler_initialization_block {
	ATR			ovratr;			/* Хϥɥ° */
	OVRHDR		ovrhdr;			/* Хϥɥεư */
} OVRINIB;

/*
 *  Хϥɥ֥åΥꥢkernel_cfg.c
 */
extern const OVRINIB	ovrinib;

/*
 *  Х󥿥ޤư椫򼨤ե饰
 */
extern bool_t	ovrtimer_flag;

/*
 *  Хϥɥ鵡ǽν
 */
extern void	initialize_overrun(void);

/*
 *  Хϥɥѥޤư
 */
extern void	ovrtimer_start(void);

/*
 *  Хϥɥѥޤ
 */
#ifndef OMIT_OVRTIMER_STOP

extern void	ovrtimer_stop(void);

#else /* OMIT_OVRTIMER_STOP */

Inline void
ovrtimer_stop(void)
{
	if (p_runtsk->leftotm > 0U) {
		p_runtsk->leftotm = target_ovrtimer_stop();
		ovrtimer_flag = false;
	}
}

#endif /* OMIT_OVRTIMER_STOP */

/*
 *  Хϥɥ鵯ư롼
 */
extern void	call_ovrhdr(void);

#endif /* TOPPERS_SUPPORT_OVRHDR */
#endif /* TOPPERS_OVERRUN_H */
