$ ======================================================================
$ 
$   TOPPERS/ASP Kernel
$       Toyohashi Open Platform for Embedded Real-Time Systems/
$       Advanced Standard Profile Kernel
$ 
$   Copyright (C) 2008-2013 by Embedded and Real-Time Systems Laboratory
$               Graduate School of Information Science, Nagoya Univ., JAPAN
$  
$   嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
$   ܥեȥѤΤޤࡥʲƱˤѡʣ
$   ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
$   (1) ܥեȥ򥽡ɤηѤˤϡ嵭
$       ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
$       ˴ޤޤƤ뤳ȡ
$   (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
$       ѤǤǺۤˤϡۤȼɥȡ
$       ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
$       ̵ݾڵǺܤ뤳ȡ
$   (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
$       ѤǤʤǺۤˤϡΤ줫ξ
$       ȡ
$     (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
$         ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
$     (b) ۤη֤̤ˡˤäơTOPPERSץȤ
$         𤹤뤳ȡ
$   (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
$       ⡤嵭ԤTOPPERSץȤդ뤳ȡ
$       ޤܥեȥΥ桼ޤϥɥ桼Τʤ
$       ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
$       դ뤳ȡ
$  
$   ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
$   TOPPERSץȤϡܥեȥ˴ؤơλŪ
$   ФŬޤơʤݾڤԤʤޤܥեȥ
$   ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
$   Ǥʤ
$ 
$   @(#) $Id$
$  
$ =====================================================================

$
$  ǡLMAVMAؤΥԡ
$
$FOREACH lma LMA.ORDER_LIST$
	$start_data = SYMBOL(LMA.START_DATA[lma])$
	$end_data = SYMBOL(LMA.END_DATA[lma])$
	$start_idata = SYMBOL(LMA.START_IDATA[lma])$
	$IF !LENGTH(start_data)$
		$ERROR$$FORMAT(_("symbol '%1%' not found"), LMA.START_DATA[lma])$$END$
	$ELIF !LENGTH(end_data)$
		$ERROR$$FORMAT(_("symbol '%1%' not found"), LMA.END_DATA[lma])$$END$
	$ELIF !LENGTH(start_idata)$
		$ERROR$$FORMAT(_("symbol '%1%' not found"), LMA.START_IDATA[lma])$$END$
	$ELSE$
		$BCOPY(start_idata, start_data, end_data - start_data)$
	$END$
$END$

$ 
$  ؿƬϤΥå
$ 
$IF CHECK_FUNC_ALIGN || CHECK_FUNC_NONNULL$
$	// ȥ㳰롼ƬϤΥå
	$tinib = SYMBOL("_kernel_tinib_table")$
	$FOREACH tskid TSK.ID_LIST$
		$task = PEEK(tinib + offsetof_TINIB_task, sizeof_FP)$
		$IF CHECK_FUNC_ALIGN && (task & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR TSK.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"task", TSK.TASK[tskid], tskid, "CRE_TSK")$$END$
		$END$
		$IF CHECK_FUNC_NONNULL && task == 0$
			$ERROR TSK.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"task", TSK.TASK[tskid], tskid, "CRE_TSK")$$END$
		$END$
		$texrtn = PEEK(tinib + offsetof_TINIB_texrtn, sizeof_FP)$
		$IF CHECK_FUNC_ALIGN && (texrtn & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR DEF_TEX.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"texrtn", TSK.TEXRTN[tskid], tskid, "DEF_TEX")$$END$
		$END$
		$tinib = tinib + sizeof_TINIB$
	$END$

$	// ϥɥƬϤΥå
	$cycinib = SYMBOL("_kernel_cycinib_table")$
	$FOREACH cycid CYC.ID_LIST$
		$cychdr = PEEK(cycinib + offsetof_CYCINIB_cychdr, sizeof_FP)$
		$IF CHECK_FUNC_ALIGN && (cychdr & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR CYC.TEXT_LINE[cycid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"cychdr", CYC.CYCHDR[cycid], cycid, "CRE_CYC")$$END$
		$END$
		$IF CHECK_FUNC_NONNULL && cychdr == 0$
			$ERROR CYC.TEXT_LINE[cycid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"cychdr", CYC.CYCHDR[cycid], cycid, "CRE_CYC")$$END$
		$END$
		$cycinib = cycinib + sizeof_CYCINIB$
	$END$

$	// 顼ϥɥƬϤΥå
	$alminib = SYMBOL("_kernel_alminib_table")$
	$FOREACH almid ALM.ID_LIST$
		$almhdr = PEEK(alminib + offsetof_ALMINIB_almhdr, sizeof_FP)$
		$IF CHECK_FUNC_ALIGN && (almhdr & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR ALM.TEXT_LINE[almid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"almhdr", ALM.ALMHDR[almid], almid, "CRE_ALM")$$END$
		$END$
		$IF CHECK_FUNC_NONNULL && almhdr == 0$
			$ERROR ALM.TEXT_LINE[almid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"almhdr", ALM.ALMHDR[almid], almid, "CRE_ALM")$$END$
		$END$
		$alminib = alminib + sizeof_ALMINIB$
	$END$

$	// ХϥɥƬϤΥå
	$ovrinib = SYMBOL("_kernel_ovrinib")$
	$IF LENGTH(OVR.ORDER_LIST)$
		$ovrhdr = PEEK(ovrinib + offsetof_OVRINIB_ovrhdr, sizeof_FP)$
		$IF CHECK_FUNC_ALIGN && (ovrhdr & (CHECK_FUNC_ALIGN - 1)) != 0$
			$ERROR OVR.TEXT_LINE[1]$E_PAR: 
				$FORMAT(_("%1% `%2%\' in %4% is not aligned"),
				"ovrhdr", OVR.OVRHDR[1], "DEF_OVR")$$END$
		$END$
		$IF CHECK_FUNC_NONNULL && ovrhdr == 0$
			$ERROR OVR.TEXT_LINE[1]$E_PAR: 
				$FORMAT(_("%1% `%2%\' in %3% is null"),
				"ovrhdr", OVR.OVRHDR[1], "DEF_OVR")$$END$
		$END$
	$END$
$END$

$ 
$  åΰƬϤΥå
$ 
$IF CHECK_STACK_ALIGN || CHECK_STACK_NONNULL$
$	// ΥåΰƬϤΥå
	$tinib = SYMBOL("_kernel_tinib_table")$
	$FOREACH tskid TSK.ID_LIST$
		$IF USE_TSKINICTXB$
			$stk = GET_STK_TSKINICTXB(tinib)$
		$ELSE$
			$stk = PEEK(tinib + offsetof_TINIB_stk, sizeof_void_ptr)$
		$END$
		$IF CHECK_STACK_ALIGN && (stk & (CHECK_STACK_ALIGN - 1)) != 0$
			$ERROR TSK.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"stk", TSK.STK[tskid], tskid, "CRE_TSK")$$END$
		$END$
		$IF CHECK_STACK_NONNULL && stk == 0$
			$ERROR TSK.TEXT_LINE[tskid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"stk", TSK.STK[tskid], tskid, "CRE_TSK")$$END$
		$END$
		$tinib = tinib + sizeof_TINIB$
	$END$

$	// 󥿥ƥѤΥåΰƬϤΥå
	$istk = PEEK(SYMBOL("_kernel_istk"), sizeof_void_ptr)$
	$IF CHECK_STACK_ALIGN && (istk & (CHECK_STACK_ALIGN - 1)) != 0$
		$ERROR ICS.TEXT_LINE[1]$E_PAR: 
			$FORMAT(_("%1% `%2%\' in %3% is not aligned"),
			"istk", ICS.ISTK[1], "DEF_ICS")$$END$
	$END$
	$IF CHECK_STACK_NONNULL && istk == 0$
		$ERROR ICS.TEXT_LINE[1]$E_PAR: 
			$FORMAT(_("%1% `%2%\' in %3% is null"),
			"istk", ICS.ISTK[1], "DEF_ICS")$$END$
	$END$
$END$

$ 
$  ĹסΰƬϤΥå
$ 
$IF CHECK_MPF_ALIGN || CHECK_MPF_NONNULL$
$	// ĹסΰƬϤΥå
	$mpfinib = SYMBOL("_kernel_mpfinib_table")$
	$FOREACH mpfid MPF.ID_LIST$
		$mpf = PEEK(mpfinib + offsetof_MPFINIB_mpf, sizeof_void_ptr)$
		$IF CHECK_MPF_ALIGN && (mpf & (CHECK_MPF_ALIGN - 1)) != 0$
			$ERROR MPF.TEXT_LINE[mpfid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is not aligned"),
				"mpf", MPF.MPF[mpfid], mpfid, "CRE_MPF")$$END$
		$END$
		$IF CHECK_MPF_NONNULL && mpf == 0$
			$ERROR MPF.TEXT_LINE[mpfid]$E_PAR: 
				$FORMAT(_("%1% `%2%\' of `%3%\' in %4% is null"),
				"mpf", MPF.MPF[mpfid], mpfid, "CRE_MPF")$$END$
		$END$
		$mpfinib = mpfinib + sizeof_MPFINIB$
	$END$
$END$
