/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007-2014 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		ߥ塼ƥåΥƥ(6)
 *
 * ڥƥȤŪ
 *
 *  ͥپ¥ߥ塼ƥåФơνλͥ
 *  βžΥߥ塼ƥåϢνŪ˥ƥȤ롥
 *
 * ڥƥȹܡ
 *
 *	(A) νλext_tsk
 *		(A-1) åƤߥ塼ƥå1ġˤå뤳ȡ
 *		(A-2) åƤߥ塼ƥå1ġˤå졤
 *			  ԤäƤåͥ٤Ѳ
 *			  뤳ȡ
 *		(A-3) åƤߥ塼ƥåʣˤ٤ƥå
 *			  뤳ȡ
 *		(A-4) åƤߥ塼ƥåʣˤå졤
 *			  ԤäƤʣˤåͥ٤
 *			  Ԥ뤳ȡλˡǥߥ塼ƥå
 *			  å˥åƤߥ塼ƥåԤ
 *			  Ƥˤ̤ͥ⤯ʤ뤳ȡ
 *	(B) ̤ͥβžrot_rdq
 *		(B-1) TPRI_SELFꤷˡΥ١ͥ٤̤ͥ
 *		ž뤳ȡ
 *		(B-2) TPRI_SELFꤷˡθͥ٤̤ͥ
 *		žʤȡ
 *
 * ڥƥȹܤμ¸ˡ
 *
 *	(A-1)
 *		ͥ٥TASK2ˤ˥ߥ塼ƥåMTX1ˤå
 *		ext_tskȡå뤳Ȥǧ롥
 *	(A-2)
 *		ͥ٥TASK2ˤ˹ͥپ¥ߥ塼ƥåMTX1ˤ
 *		̤ͥ٥TASK3ˤMTX1Ԥ֤ǡ
 *		TASK2 ext_tskȡTASK3ͥ٤ˤʤäԤ뤳
 *		Ȥǧ롥
 *	(A-3)
 *		ͥ٥TASK2ˤ˥ߥ塼ƥå2ġMTX1MTX2˥
 *		ext_tskȡξΥå뤳Ȥǧ롥
 *	(A-4)
 *		ͥ٥TASK2ˤ˹ͥپ¥ߥ塼ƥå2ġMTX1
 *		MTX2ˤ򤳤νǥå̤ͥ٥2ġTASK3
 *		TASK4ˤˤ줾ΥåԤ֤ǡTASK2ext_tskȡ
 *		TASK3TASK4ͥ٤ˤʤäԤ뤳Ȥǧ롥
 *		˥åƤߥ塼ƥåMTX1ˤԤäƤ
 *		TASK3ˤTASK4̤ͥ⤯ʤ뤳Ȥǧ롥
 *	(B-1)
 *		ͥ٥3ġTASK2TASK3TASK4ˤ¹ԤǤ֤λ
 *		ˡ1Ĥͥ٥TASK2ˤ˹ͥپ¥ߥ塼ƥå
 *		årot_rdq(TPRI_SELF)ȡĤ2Ĥͥ٥
 *		̤ͥž뤳Ȥǧ롥
 *	(B-2)
 *		Ʊǡͥ٥̤ͥžʤȤǧ
 *		롥
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	TASK4: ͥ٥
 *	MTX1: ߥ塼ƥåTA_CEILING°¤Ϲͥ١
 *	MTX2: ߥ塼ƥåTA_CEILING°¤Ϲͥ١
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *		call(set_bit_func(bit_mutex))
 *	1:	act_tsk(TASK2)
 *	2:	rot_rdq(TPRI_SELF)
 *	//		㡧TASK2TASK1
 *	== TASK2-1ͥ١1 ==
 *	3:	loc_mtx(MTX1)
 *	//		⡧TASK2㡧TASK1MTX1TASK2
 *	4:	ext_tsk() -> noreturn			... (A-1)
 *	//		㡧TASK1
 *	== TASK1³==
 *	5:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TSK_NONE)
 *		assert(rmtx.wtskid == TSK_NONE)
 *
 *	6:	act_tsk(TASK2)
 *		act_tsk(TASK3)
 *	7:	rot_rdq(TPRI_SELF)
 *	//		㡧TASK2TASK3TASK1
 *	== TASK2-2ͥ١2 ==
 *	8:	loc_mtx(MTX1)
 *	//		⡧TASK2㡧TASK3TASK1MTX1TASK2
 *	9:	slp_tsk()
 *	//		㡧TASK3TASK1MTX1TASK2
 *	== TASK3ͥ١==
 *	10:	loc_mtx(MTX1)
 *	//		㡧TASK1MTX1TASK2TASK3
 *	== TASK1³==
 *	11:	wup_tsk(TASK2)
 *	//		⡧TASK2㡧TASK1MTX1TASK2TASK3
 *	== TASK2-2³==
 *	12:	ext_tsk() -> noreturn			... (A-2)
 *	//		⡧TASK3㡧TASK1MTX1TASK3
 *	== TASK3³==
 *	13:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TASK3)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		get_pri(TPRI_SELF, &tskpri)
 *		assert(tskpri == HIGH_PRIORITY)
 *		unl_mtx(MTX1)
 *		slp_tsk()
 *	//		㡧TASK1
 *
 *	== TASK1³==
 *	14:	act_tsk(TASK2)
 *	15:	rot_rdq(TPRI_SELF)
 *	//		㡧TASK2TASK1
 *	== TASK2-3ͥ١3 ==
 *	16:	loc_mtx(MTX1)
 *		loc_mtx(MTX2)
 *	//		⡧TASK2㡧TASK1MTX1TASK2MTX2TASK2
 *	17:	ext_tsk() -> noreturn			... (A-3)
 *	//		㡧TASK1
 *	== TASK1³==
 *	18:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TSK_NONE)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		ref_mtx(MTX2, &rmtx)
 *		assert(rmtx.htskid == TSK_NONE)
 *		assert(rmtx.wtskid == TSK_NONE)
 *
 *	19:	act_tsk(TASK2)
 *		wup_tsk(TASK3)
 *		act_tsk(TASK4)
 *	20:	rot_rdq(TPRI_SELF)
 *	//		㡧TASK2TASK3TASK4TASK1
 *	== TASK2-4ͥ١4 ==
 *	21:	loc_mtx(MTX1)
 *		loc_mtx(MTX2)
 *	//		⡧TASK2㡧TASK3TASK4TASK1MTX1TASK2MTX2TASK2
 *	22:	chg_pri(TASK1, HIGH_PRIORITY)
 *	//		⡧TASK2TASK1㡧TASK3TASK4MTX1TASK2MTX2TASK2
 *	23:	rot_rdq(TPRI_SELF)				... (B-1)(B-2)
 *	//		⡧TASK2TASK1㡧TASK4TASK3MTX1TASK2MTX2TASK2
 *	24:	slp_tsk()
 *	//		⡧TASK1㡧TASK4TASK3MTX1TASK2MTX2TASK2
 *	== TASK1³==
 *	25:	chg_pri(TSK_SELF, TPRI_INI)
 *	//		㡧TASK4TASK3TASK1MTX1TASK2MTX2TASK2
 *	== TASK4ͥ١==
 *	26:	loc_mtx(MTX2)
 *	//		㡧TASK3TASK1MTX1TASK2MTX2TASK2TASK4
 *	== TASK3³==
 *	27:	loc_mtx(MTX1)
 *	//		㡧TASK1MTX1TASK2TASK3MTX2TASK2TASK4
 *	== TASK1³==
 *	28:	wup_tsk(TASK2)
 *	//		⡧TASK2㡧TASK1MTX1TASK2TASK3MTX2TASK2TASK4
 *	== TASK2-4³==
 *	29:	ext_tsk() -> noreturn			... (A-4)
 *	//		⡧TASK4TASK3㡧TASK1MTX1TASK3MTX2TASK4
 *	== TASK4³==
 *	30:	ref_mtx(MTX1, &rmtx)
 *		assert(rmtx.htskid == TASK3)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		ref_mtx(MTX2, &rmtx)
 *		assert(rmtx.htskid == TASK4)
 *		assert(rmtx.wtskid == TSK_NONE)
 *		get_pri(TPRI_SELF, &tskpri)
 *		assert(tskpri == HIGH_PRIORITY)
 *		ext_tsk() -> noreturn
 *	//		⡧TASK3㡧TASK1MTX2TASK4
 *	== TASK3³==
 *	31:	get_pri(TPRI_SELF, &tskpri)
 *		assert(tskpri == HIGH_PRIORITY)
 *		ext_tsk() -> noreturn
 *	//		㡧TASK1
 *	== TASK1³==
 *	32:	END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_mutex6.h"

extern ER	bit_mutex(void);

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;
	T_RMTX	rmtx;

	test_start(__FILE__);

	set_bit_func(bit_mutex);

	check_point(1);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(2);
	ercd = rot_rdq(TPRI_SELF);
	check_ercd(ercd, E_OK);

	check_point(5);
	ercd = ref_mtx(MTX1, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TSK_NONE);

	check_assert(rmtx.wtskid == TSK_NONE);

	check_point(6);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(7);
	ercd = rot_rdq(TPRI_SELF);
	check_ercd(ercd, E_OK);

	check_point(11);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(15);
	ercd = rot_rdq(TPRI_SELF);
	check_ercd(ercd, E_OK);

	check_point(18);
	ercd = ref_mtx(MTX1, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TSK_NONE);

	check_assert(rmtx.wtskid == TSK_NONE);

	ercd = ref_mtx(MTX2, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TSK_NONE);

	check_assert(rmtx.wtskid == TSK_NONE);

	check_point(19);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = rot_rdq(TPRI_SELF);
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = chg_pri(TSK_SELF, TPRI_INI);
	check_ercd(ercd, E_OK);

	check_point(28);
	ercd = wup_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_finish(32);
	check_point(0);
}

static uint_t	task2_count = 0;

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;

	switch (++task2_count) {
	case 1:
		check_point(3);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(4);
		ercd = ext_tsk();

		check_point(0);

	case 2:
		check_point(8);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		check_point(9);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(12);
		ercd = ext_tsk();

		check_point(0);

	case 3:
		check_point(16);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		ercd = loc_mtx(MTX2);
		check_ercd(ercd, E_OK);

		check_point(17);
		ercd = ext_tsk();

		check_point(0);

	case 4:
		check_point(21);
		ercd = loc_mtx(MTX1);
		check_ercd(ercd, E_OK);

		ercd = loc_mtx(MTX2);
		check_ercd(ercd, E_OK);

		check_point(22);
		ercd = chg_pri(TASK1, HIGH_PRIORITY);
		check_ercd(ercd, E_OK);

		check_point(23);
		ercd = rot_rdq(TPRI_SELF);
		check_ercd(ercd, E_OK);

		check_point(24);
		ercd = slp_tsk();
		check_ercd(ercd, E_OK);

		check_point(29);
		ercd = ext_tsk();

		check_point(0);

	default:
		check_point(0);
	}
	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;
	T_RMTX	rmtx;

	check_point(10);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = ref_mtx(MTX1, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TASK3);

	check_assert(rmtx.wtskid == TSK_NONE);

	ercd = get_pri(TPRI_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == HIGH_PRIORITY);

	ercd = unl_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(27);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = get_pri(TPRI_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == HIGH_PRIORITY);

	ercd = ext_tsk();

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;
	T_RMTX	rmtx;

	check_point(26);
	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = ref_mtx(MTX1, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TASK3);

	check_assert(rmtx.wtskid == TSK_NONE);

	ercd = ref_mtx(MTX2, &rmtx);
	check_ercd(ercd, E_OK);

	check_assert(rmtx.htskid == TASK4);

	check_assert(rmtx.wtskid == TSK_NONE);

	ercd = get_pri(TPRI_SELF, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == HIGH_PRIORITY);

	ercd = ext_tsk();

	check_point(0);
}
