/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2007-2013 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/* 
 *		ߥ塼ƥåΥƥ(5)
 *
 * ڥƥȤŪ
 *
 *  ͥپ¥ߥ塼ƥåФơߥ塼ƥåκƽ
 *  Ū˥ƥȤ롥change_prioritymutex_calc_priority
 *  ƤˤƧ߹ޤʤ
 *
 * ڥƥȹܡ
 *
 *	(A) ߥ塼ƥåνini_mtxˤȼߥ塼ƥåå
 *		Ƥʼ¹ԤǤ֡ˤͥѹ
 *		(A-1) ߥ塼ƥåξͥ٤ߥ塼ƥå
 *			  åƤʼ¹ԤǤ֡ˤθͥ٤Ʊ
 *			  ǡߥ塼ƥåΥåͥ٤٤ˡ
 *			  ͥ٤Ŭڤ˲뤳ȡޤƱͥ
 *			  Ǥ̤ͥǹˤʤ뤳
 *		(A-2) ߥ塼ƥåξͥ٤ߥ塼ƥå
 *			  åƤʼ¹ԤǤ֡ˤθͥ٤Ʊ
 *			  ǡߥ塼ƥåΥåͥ٤Ѥ٤Ǥʤ
 *			  ˡͥ٤ѤʤȡޤƱͥ
 *			  Ǥ̤ͥѤʤ
 *		(A-3) ߥ塼ƥåξͥ٤ߥ塼ƥå
 *			  åƤʼ¹ԤǤ֡ˤθͥ٤
 *			  㤤ˡͥ٤ѤʤȡޤƱ
 *			  ͥǤ̤ͥѤʤ
 *		(A-4) (A-1)η̡ǥѥå뤳ȡ
 *	(B) ߥ塼ƥåνini_mtxˤȼߥ塼ƥåå
 *		ƤԤ֡ˤͥѹ
 *		(B-1) ߥ塼ƥåξͥ٤ߥ塼ƥå
 *			  åƤԤ֡ˤθͥ٤Ʊǡ
 *			  ߥ塼ƥåΥåͥ٤٤ˡ
 *			  ͥ٤Ŭڤ˲뤳ȡޤƱͥ
 *			  ǤνǸˤʤ뤳
 *		(B-2) ߥ塼ƥåξͥ٤ߥ塼ƥå
 *			  åƤԤ֡ˤθͥ٤Ʊǡ
 *			  ߥ塼ƥåΥåͥ٤Ѥ٤Ǥʤ
 *			  ˡͥ٤ѤʤȡޤƱͥ
 *			  ǤνѤʤ
 *		(B-3) ߥ塼ƥåξͥ٤ߥ塼ƥå
 *			  åƤԤ֡ˤθͥ٤㤤
 *			  ˡͥ٤ѤʤȡޤƱͥ
 *			  ǤνѤʤ
 *	(C) ߥ塼ƥåνini_mtxˤȼߥ塼ƥåԤäƤ
 *		ξѲ
 *		(C-1) ߥ塼ƥåԤäƤԤ뤳ȡ
 *		(C-2) (C-1)η̡ǥѥå뤳ȡ
 *
 * ڥƥȹܤμ¸ˡ
 *
 *	(A-1)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		å֤ǡͥ٥TASK5ˤMTX1ƽ
 *		TASK1ͥ٤ͥ٤˲뤳Ȥǧ롥ޤ¹Բǽ
 *		֤ͥ٥TASK2ˤ⡤̤ͥ⤯ʤ뤳Ȥǧ
 *		롥
 *	(A-2)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥå2
 *		MTX1MTX2ˤå֤ǡͥ٥TASK5ˤ
 *		MTX1ƽTASK1ͥ٤ѲʤȤǧ롥ޤ
 *		¹Բǽ֤ͥ٥2ġTASK3TASK4ˤѰդƤ
 *		̤ͥѤʤȤǧ롥
 *	(A-3)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX2ˤ
 *		ͥپ¥ߥ塼ƥåMTX3ˤå֤ǡͥ
 *		TASK5ˤMTX3ƽTASK1ͥ٤Ѳʤ
 *		Ȥǧ롥ޤ¹Բǽ֤ͥ٥2ġTASK3
 *		TASK4ˤѰդƤ̤ͥѤʤȤǧ롥
 *	(A-4)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX2ˤ
 *		å֤ǡTASK1MTX2ƽTASK1ͥ٤
 *		ͥ٤˲ꡤ¹Բǽ֤ͥ٥TASK4ˤڤ괹
 *		뤳Ȥǧ롥ޤ¹Բǽ֤ͥ٥TASK2ˤ
 *		⡤̤ͥ⤯ʤ뤳Ȥǧ롥
 *	(B-1)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		å֤ǡ̤Υߥ塼ƥåMTX4Ԥ֤Ȥͥ
 *		٥TASK5ˤMTX1ƽTASK1ͥ٤ͥ
 *		٤˲뤳Ȥǧ롥ޤMTX4Ԥ֤ͥ٥
 *		TASK2ˤ⡤ԤǤνˤʤ뤳Ȥǧ롥
 *	(B-2)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥå2
 *		MTX1MTX2ˤå֤ǡ̤Υߥ塼ƥåMTX4
 *		֤Ȥͥ٥TASK5ˤMTX1ƽTASK1
 *		ͥ٤ѲʤȤǧ롥ޤMTX4Ԥ֤ͥ
 *		٥2ġTASK3TASK4ˤѰդƤԤǤν
 *		ѤʤȤǧ롥
 *	(B-3)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX2ˤ
 *		ͥپ¥ߥ塼ƥåMTX3ˤå֤ǡ̤Υߥ塼
 *		ƥåMTX4Ԥ֤Ȥͥ٥TASK5ˤMTX3
 *		ƽTASK1ͥ٤ѲʤȤǧ롥ޤ
 *		MTX4Ԥ֤ͥ٥2ġTASK3TASK4ˤѰդƤ
 *		ԤǤνѤʤȤǧ롥
 *	(C-1)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		ͥ٥TASK3ˤMTX1ԤäƤ֤ǡͥ
 *		TASK5ˤMTX1ƽTASK3Ԥ뤳
 *		ǧ롥ޤ¹Բǽ֤ͥ٥TASK4ˤ⡤
 *		TASK3̤ͥ㤯ʤ뤳Ȥǧ롥
 *	(C-2)
 *		ͥ٥TASK1ˤͥپ¥ߥ塼ƥåMTX1ˤ
 *		ͥ٥TASK3ˤMTX1ԤTASK1򵯾Ԥ
 *		Ȥ֤ǡ̤ͥ٥TASK2ˤMTX1ƽ
 *		TASK3Ԥ졤TASK3ڤ괹뤳Ȥǧ롥
 *
 * ڻѥ꥽
 *
 *	TASK1: ͥ٥ᥤ󥿥ǽ餫鵯ư
 *	TASK2: ͥ٥
 *	TASK3: ͥ٥
 *	TASK4: ͥ٥
 *	TASK5: ͥ٥
 *	MTX1: ߥ塼ƥåTA_CEILING°¤ͥ١
 *	MTX2: ߥ塼ƥåTA_CEILING°¤ͥ١
 *	MTX3: ߥ塼ƥåTA_CEILING°¤ͥ١
 *	MTX4: ߥ塼ƥåTA_CEILING°¤Ϲͥ١
 *
 * ڥƥȥ󥹡
 *
 *	== TASK1ͥ١==
 *		call(set_bit_func(bit_mutex))
 *	1:	loc_mtx(MTX1)
 *	2:	act_tsk(TASK2)
 *	3:	act_tsk(TASK5)
 *	//		⡧TASK5桧TASK1㡧TASK2MTX1TASK1
 *	== TASK5ͥ١==
 *	4:	ini_mtx(MTX1)			... (A-1)
 *	//		⡧TASK5㡧TASK1TASK2
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == LOW_PRIORITY)
 *	5:	slp_tsk()
 *	//		㡧TASK1TASK2
 *
 *	== TASK1³==
 *	6:	sus_tsk(TASK2)
 *	7:	loc_mtx(MTX1)
 *		loc_mtx(MTX2)
 *	8:	act_tsk(TASK3)
 *	//		桧TASK1TASK3MTX1TASK1MTX2TASK1
 *	9:	dis_dsp()
 *	10:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK3TASK1MTX1TASK1MTX2TASK1
 *	11:	act_tsk(TASK4)
 *	//		桧TASK3TASK1TASK4MTX1TASK1MTX2TASK1
 *	12:	wup_tsk(TASK5)
 *	//		⡧TASK5桧TASK3TASK1TASK4MTX1TASK1MTX2TASK1
 *	13:	ena_dsp()
 *	== TASK5³==
 *	14:	ini_mtx(MTX1)			... (A-2)
 *	//		⡧TASK5桧TASK3TASK1TASK4MTX2TASK1
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	15:	slp_tsk()
 *	//		桧TASK3TASK1TASK4MTX2TASK1
 *	== TASK3ͥ١==
 *	16:	slp_tsk()
 *	//		桧TASK1TASK4MTX2TASK1
 *	== TASK1³==
 *	17:	slp_tsk()
 *	//		桧TASK4MTX2TASK1
 *	== TASK4ͥ١==
 *	18:	wup_tsk(TASK1)
 *	//		桧TASK4TASK1MTX2TASK1
 *	19:	slp_tsk()
 *	//		桧TASK1MTX2TASK1
 *
 *	== TASK1³==
 *	20:	loc_mtx(MTX3)
 *	//		桧TASK1MTX2TASK1MTX3TASK1
 *	21:	wup_tsk(TASK3)
 *	//		桧TASK1TASK3MTX2TASK1MTX3TASK1
 *	22:	dis_dsp()
 *	23:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK3TASK1MTX2TASK1MTX3TASK1
 *	24:	wup_tsk(TASK4)
 *	//		桧TASK3TASK1TASK4MTX2TASK1MTX3TASK1
 *	25:	wup_tsk(TASK5)
 *	//		⡧TASK5桧TASK3TASK1TASK4MTX2TASK1MTX3TASK1
 *	26:	ena_dsp()
 *	== TASK5³==
 *	27:	ini_mtx(MTX3)			... (A-3)
 *	//		⡧TASK5桧TASK3TASK1TASK4MTX2TASK1
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	28:	slp_tsk()
 *	//		桧TASK3TASK1TASK4MTX2TASK1
 *	== TASK3³==
 *	29:	slp_tsk()
 *	//		桧TASK1TASK4MTX2TASK1
 *
 *	== TASK1³==
 *	30:	slp_tsk()
 *	//		桧TASK4MTX2TASK1
 *	== TASK4³==
 *	31:	wup_tsk(TASK1)
 *	//		桧TASK4TASK1MTX2TASK1
 *	32:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK1TASK4MTX2TASK1
 *	== TASK1³==
 *	33:	rsm_tsk(TASK2)
 *	//		桧TASK1TASK4㡧TASK2MTX2TASK1
 *	34:	ini_mtx(MTX2)			... (A-4)
 *	//		桧TASK4㡧TASK1TASK2
 *	== TASK4³==
 *	35:	get_pri(TASK1, &tskpri)
 *		assert(tskpri == LOW_PRIORITY)
 *	36:	slp_tsk()
 *	//		㡧TASK1TASK2
 *
 *	== TASK1³==
 *	37:	wup_tsk(TASK5)
 *	== TASK5³==
 *	38:	loc_mtx(MTX4)
 *	39:	tslp_tsk(10) -> E_TMOUT
 *	//		㡧TASK1TASK2MTX4TASK5
 *	== TASK1³==
 *	40:	loc_mtx(MTX1)
 *	//		桧TASK1㡧TASK2MTX1TASK1MTX4TASK5
 *	41:	loc_mtx(MTX4)
 *	//		㡧TASK2MTX1TASK1MTX4TASK5TASK1
 *	== TASK2ͥ١==
 *	42:	loc_mtx(MTX4)
 *	//		MTX1TASK1MTX4TASK5TASK1TASK2
 *	//		ॢԤ
 *	//		⡧TASK5MTX1TASK1MTX4TASK5TASK1TASK2
 *	== TASK5³==
 *	43:	ini_mtx(MTX1)			... (B-1)
 *	//		⡧TASK5MTX4TASK5TASK2TASK1
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == LOW_PRIORITY)
 *	44:	unl_mtx(MTX4)
 *	//		⡧TASK5TASK2MTX4TASK2TASK1
 *	45:	slp_tsk()
 *	//		⡧TASK2MTX4TASK2TASK1
 *	== TASK2³==
 *	46:	unl_mtx(MTX4)
 *	//		⡧TASK1㡧TASK2MTX4TASK1
 *	== TASK1³==
 *	47:	unl_mtx(MTX4)
 *	//		㡧TASK1TASK2
 *
 *	48:	wup_tsk(TASK5)
 *	== TASK5³==
 *	49:	loc_mtx(MTX4)
 *	50:	slp_tsk()
 *	//		㡧TASK1TASK2MTX4TASK5
 *	== TASK1³==
 *	51:	wup_tsk(TASK3)
 *	//		桧TASK3㡧TASK1TASK2MTX4TASK5
 *	== TASK3³==
 *	52:	loc_mtx(MTX4)
 *	//		㡧TASK1TASK2MTX4TASK5TASK3
 *	== TASK1³==
 *	53:	loc_mtx(MTX1)
 *		loc_mtx(MTX2)
 *	//		桧TASK1㡧TASK2MTX1TASK1MTX2TASK1MTX4TASK5TASK3
 *	54:	loc_mtx(MTX4)
 *	//		㡧TASK2MTX1TASK1MTX2TASK1MTX4TASK5TASK3TASK1
 *	== TASK2³==
 *	55:	wup_tsk(TASK4)
 *	== TASK4³==
 *	56:	loc_mtx(MTX4)
 *	//		㡧TASK2MTX1TASK1MTX2TASK1
 *	//								MTX4TASK5TASK3TASK1TASK4
 *	== TASK2³==
 *	57:	wup_tsk(TASK5)
 *	//		⡧TASK5㡧TASK2MTX1TASK1MTX2TASK1
 *	//								MTX4TASK5TASK3TASK1TASK4
 *	== TASK5³==
 *	58:	ini_mtx(MTX1)			... (B-2)
 *	//		⡧TASK5㡧TASK2MTX2TASK1MTX4TASK5TASK3TASK1TASK4
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	59:	unl_mtx(MTX4)
 *	//		⡧TASK5TASK3㡧TASK2MTX2TASK1MTX4TASK3TASK1TASK4
 *	60:	slp_tsk()
 *	//		⡧TASK3㡧TASK2MTX2TASK1MTX4TASK3TASK1TASK4
 *	== TASK3³==
 *	61:	unl_mtx(MTX4)
 *	//		⡧TASK1桧TASK3㡧TASK2MTX2TASK1MTX4TASK1TASK4
 *	== TASK1³==
 *	62:	unl_mtx(MTX4)
 *	//		⡧TASK4桧TASK1TASK3㡧TASK2MTX2TASK1MTX4TASK4
 *	== TASK4³==
 *	63:	unl_mtx(MTX4)
 *	//		桧TASK4TASK1TASK3㡧TASK2MTX2TASK1
 *	64:	slp_tsk()
 *	//		桧TASK1TASK3㡧TASK2MTX2TASK1
 *	== TASK1³==
 *	65:	slp_tsk()
 *	//		桧TASK3㡧TASK2MTX2TASK1
 *	== TASK3³==
 *	66:	slp_tsk()
 *	//		㡧TASK2MTX2TASK1
 *
 *	== TASK2³==
 *	67: wup_tsk(TASK5)
 *	== TASK5³==
 *	68:	loc_mtx(MTX4)
 *	69:	slp_tsk()
 *	//		㡧TASK2MTX4TASK5
 *	== TASK2³==
 *	70:	wup_tsk(TASK3)
 *	== TASK3³==
 *	71:	loc_mtx(MTX4)
 *	//		㡧TASK2MTX4TASK5TASK3
 *	== TASK2³==
 *	72:	wup_tsk(TASK1)
 *	//		桧TASK1㡧TASK2MTX4TASK5
 *	== TASK1³==
 *	73:	loc_mtx(MTX3)
 *	//		桧TASK1㡧TASK2MTX2TASK1MTX3TASK1MTX4TASK5TASK3
 *	74:	loc_mtx(MTX4)
 *	//		㡧TASK2MTX2TASK1MTX3TASK1MTX4TASK5TASK3TASK1
 *	== TASK2³==
 *	75:	wup_tsk(TASK4)
 *	== TASK4³==
 *	76:	loc_mtx(MTX4)
 *	//		㡧TASK2MTX2TASK1MTX3TASK1
 *	//								MTX4TASK5TASK3TASK1TASK4
 *	== TASK2³==
 *	77:	wup_tsk(TASK5)
 *	//		⡧TASK5㡧TASK2MTX2TASK1MTX3TASK1
 *	//								MTX4TASK5TASK3TASK1TASK4
 *	== TASK5³==
 *	78:	ini_mtx(MTX3)			... (B-3)
 *	//		⡧TASK5㡧TASK2MTX2TASK1MTX4TASK5TASK3TASK1TASK4
 *		get_pri(TASK1, &tskpri)
 *		assert(tskpri == MID_PRIORITY)
 *	79:	unl_mtx(MTX4)
 *	//		⡧TASK5TASK3㡧TASK2MTX2TASK1MTX4TASK3TASK1TASK4
 *	80:	slp_tsk()
 *	//		⡧TASK3㡧TASK2MTX2TASK1MTX4TASK3TASK1TASK4
 *	== TASK3³==
 *	81:	unl_mtx(MTX4)
 *	//		⡧TASK1桧TASK3㡧TASK2MTX2TASK1MTX4TASK1TASK4
 *	== TASK1³==
 *	82:	unl_mtx(MTX4)
 *	//		⡧TASK4桧TASK1TASK3㡧TASK2MTX2TASK1MTX4TASK4
 *	== TASK4³==
 *	83:	unl_mtx(MTX4)
 *	//		桧TASK4TASK1TASK3㡧TASK2MTX2TASK1
 *	84:	slp_tsk()
 *	//		桧TASK1TASK3㡧TASK2MTX2TASK1
 *	== TASK1³==
 *	85:	unl_mtx(MTX2)
 *	//		桧TASK3㡧TASK1TASK2
 *	== TASK3³==
 *	86:	slp_tsk()
 *	//		㡧TASK1TASK2
 *
 *	== TASK1³==
 *	87:	sus_tsk(TASK2)
 *	//		㡧TASK1
 *	88:	loc_mtx(MTX1)
 *	//		桧TASK1MTX1TASK1
 *	89:	wup_tsk(TASK3)
 *	//		桧TASK1TASK3MTX1TASK1
 *	90:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK3TASK1MTX1TASK1
 *	== TASK3³==
 *	91:	loc_mtx(MTX1) -> E_DLT
 *	//		桧TASK1MTX1TASK1TASK3
 *	== TASK1³==
 *	92:	wup_tsk(TASK5)
 *	//		⡧TASK5桧TASK1MTX1TASK1TASK3
 *	== TASK5³==
 *	93:	wup_tsk(TASK4)
 *	//		⡧TASK5桧TASK1TASK4MTX1TASK1TASK3
 *	94:	ini_mtx(MTX1)			... (C-1)
 *	//		⡧TASK5桧TASK4TASK3㡧TASK1
 *	95:	ext_tsk() -> noreturn
 *	//		桧TASK4TASK3㡧TASK1
 *	== TASK4³==
 *	96:	ext_tsk() -> noreturn
 *	//		桧TASK3㡧TASK1
 *	== TASK3³==
 *	97:	slp_tsk()
 *	//		㡧TASK1
 *
 *	== TASK1³==
 *	98:	loc_mtx(MTX1)
 *	//		桧TASK1MTX1TASK1
 *	99:	wup_tsk(TASK3)
 *	//		桧TASK1TASK3MTX1TASK1
 * 100:	rot_rdq(MID_PRIORITY)
 *	//		桧TASK3TASK1MTX1TASK1
 *	== TASK3³==
 * 101:	loc_mtx(MTX1) -> E_DLT
 *	//		桧TASK1MTX1TASK1TASK3
 *	== TASK1³==
 * 102:	rsm_tsk(TASK2)
 *	//		桧TASK1㡧TASK2MTX1TASK1TASK3
 * 103:	slp_tsk()
 *	//		㡧TASK2MTX1TASK1TASK3
 *	== TASK2³==
 * 104:	ini_mtx(MTX1)			... (C-2)
 *	//		桧TASK3㡧TASK2
 *	== TASK3³==
 * 105:	ext_tsk() -> noreturn
 *	//		㡧TASK2
 *	== TASK2³==
 * 106:	ter_tsk(TASK1)
 * 107:	END
 */

#include <kernel.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "test_lib.h"
#include "test_mutex5.h"

extern ER	bit_mutex(void);

/* DO NOT DELETE THIS LINE -- gentest depends on it. */

void
task1(intptr_t exinf)
{
	ER_UINT	ercd;

	test_start(__FILE__);

	set_bit_func(bit_mutex);

	check_point(1);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(2);
	ercd = act_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(3);
	ercd = act_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(6);
	ercd = sus_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(7);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(8);
	ercd = act_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(9);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(10);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(11);
	ercd = act_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(12);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(13);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(17);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(20);
	ercd = loc_mtx(MTX3);
	check_ercd(ercd, E_OK);

	check_point(21);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(22);
	ercd = dis_dsp();
	check_ercd(ercd, E_OK);

	check_point(23);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(24);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(25);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(26);
	ercd = ena_dsp();
	check_ercd(ercd, E_OK);

	check_point(30);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(33);
	ercd = rsm_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(34);
	ercd = ini_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(37);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(40);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(41);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(47);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(48);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(51);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(53);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = loc_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(54);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(62);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(65);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(73);
	ercd = loc_mtx(MTX3);
	check_ercd(ercd, E_OK);

	check_point(74);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(82);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(85);
	ercd = unl_mtx(MTX2);
	check_ercd(ercd, E_OK);

	check_point(87);
	ercd = sus_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(88);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(89);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(90);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(92);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(98);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(99);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(100);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(102);
	ercd = rsm_tsk(TASK2);
	check_ercd(ercd, E_OK);

	check_point(103);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(0);
}

void
task2(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(42);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(46);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(55);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(57);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(67);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(70);
	ercd = wup_tsk(TASK3);
	check_ercd(ercd, E_OK);

	check_point(72);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(75);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(77);
	ercd = wup_tsk(TASK5);
	check_ercd(ercd, E_OK);

	check_point(104);
	ercd = ini_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(106);
	ercd = ter_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_finish(107);
	check_point(0);
}

void
task3(intptr_t exinf)
{
	ER_UINT	ercd;

	check_point(16);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(29);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(52);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(61);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(66);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(71);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(81);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(86);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(91);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_DLT);

	check_point(97);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(101);
	ercd = loc_mtx(MTX1);
	check_ercd(ercd, E_DLT);

	check_point(105);
	ercd = ext_tsk();

	check_point(0);
}

void
task4(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;

	check_point(18);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(19);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(31);
	ercd = wup_tsk(TASK1);
	check_ercd(ercd, E_OK);

	check_point(32);
	ercd = rot_rdq(MID_PRIORITY);
	check_ercd(ercd, E_OK);

	check_point(35);
	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == LOW_PRIORITY);

	check_point(36);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(56);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(63);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(64);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(76);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(83);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(84);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(96);
	ercd = ext_tsk();

	check_point(0);
}

void
task5(intptr_t exinf)
{
	ER_UINT	ercd;
	PRI		tskpri;

	check_point(4);
	ercd = ini_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == LOW_PRIORITY);

	check_point(5);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(14);
	ercd = ini_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(15);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(27);
	ercd = ini_mtx(MTX3);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(28);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(38);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(39);
	ercd = tslp_tsk(10);
	check_ercd(ercd, E_TMOUT);

	check_point(43);
	ercd = ini_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == LOW_PRIORITY);

	check_point(44);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(45);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(49);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(50);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(58);
	ercd = ini_mtx(MTX1);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(59);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(60);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(68);
	ercd = loc_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(69);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(78);
	ercd = ini_mtx(MTX3);
	check_ercd(ercd, E_OK);

	ercd = get_pri(TASK1, &tskpri);
	check_ercd(ercd, E_OK);

	check_assert(tskpri == MID_PRIORITY);

	check_point(79);
	ercd = unl_mtx(MTX4);
	check_ercd(ercd, E_OK);

	check_point(80);
	ercd = slp_tsk();
	check_ercd(ercd, E_OK);

	check_point(93);
	ercd = wup_tsk(TASK4);
	check_ercd(ercd, E_OK);

	check_point(94);
	ercd = ini_mtx(MTX1);
	check_ercd(ercd, E_OK);

	check_point(95);
	ercd = ext_tsk();

	check_point(0);
}
