/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2005-2012 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ߥ塼ƥåǽ
 */

#ifndef TOPPERS_MUTEX_H
#define TOPPERS_MUTEX_H

#include "wait.h"

/*
 *  ߥ塼ƥå֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥν֥åζʬ
 *  WOBJINIBˤĥʥ֥ȻظηѾˤΤǡ
 *  ǽΥեɤ̤ˤʤäƤ롥
 */
typedef struct mutex_initialization_block {
	ATR			mtxatr;			/* ߥ塼ƥå° */
	uint_t		ceilpri;		/* ߥ塼ƥåξͥ١ɽ*/
} MTXINIB;

/*
 *  ߥ塼ƥå֥å
 *
 *  ι¤ΤϡƱ֥̿Ȥδ֥åζʬWOBJCB
 *  ĥʥ֥ȻظηѾˤΤǡǽ2Ĥ
 *  եɤ̤ˤʤäƤ롥
 */
typedef struct mutex_control_block {
	QUEUE		wait_queue;		/* ߥ塼ƥåԤ塼 */
	const MTXINIB *p_mtxinib;	/* ֥åؤΥݥ */
	TCB			*p_loctsk;		/* ߥ塼ƥååƤ륿 */
	QUEUE		mutex_queue;	/* åƤߥ塼ƥåΥ塼 */
} MTXCB;

/*
 *  ߥ塼ƥåԤ֥å
 *
 *  ι¤ΤϡƱ֥̿ȤԤ֥åζʬ
 *  WINFO_WOBJˤĥʥ֥ȻظηѾˤΤǡ
 *  ٤ƤΥեɤ̤ˤʤäƤ롥
 */
typedef struct mutex_waiting_information {
	WINFO	winfo;			/* ɸԤ֥å */
	MTXCB	*p_mtxcb;		/* ԤäƤߥ塼ƥåδ֥å */
} WINFO_MTX;

/*
 *  ߥ塼ƥåIDκ͡kernel_cfg.c
 */
extern const ID	tmax_mtxid;

/*
 *  ߥ塼ƥå֥åΥꥢkernel_cfg.c
 */
extern const MTXINIB	mtxinib_table[];

/*
 *  ߥ塼ƥå֥åΥꥢkernel_cfg.c
 */
extern MTXCB	mtxcb_table[];

/*
 *  ߥ塼ƥå֥åߥ塼ƥåIDФΥޥ
 */
#define	MTXID(p_mtxcb)	((ID)(((p_mtxcb) - mtxcb_table) + TMIN_MTXID))

/*
 *  ߥ塼ƥåǽν
 */
extern void	initialize_mutex(void);

/*
 *  ٰͥȿΥå
 *
 *  chg_priǾٰͥȿΥåԤѤؿǤꡤ
 *  p_tcbǻꤵ륿åƤͥپ¥ߥ塼ƥåȡ
 *  åԤäƤͥپ¥ߥ塼ƥåǡͥ٤
 *  bpriority㤤Τfalse򡤤Ǥʤtrue֤
 */
extern bool_t	(*mtxhook_check_ceilpri)(TCB *p_tcb, uint_t bpriority);
extern bool_t	mutex_check_ceilpri(TCB *p_tcb, uint_t bpriority);

/* 
 *  ͥپ¥ߥ塼ƥååƤ뤫Υå
 *
 *  p_tcbǻꤵ륿ͥپ¥ߥ塼ƥååƤ
 *  trueǤʤfalse֤
 */
extern bool_t	(*mtxhook_scan_ceilmtx)(TCB *p_tcb);
extern bool_t	mutex_scan_ceilmtx(TCB *p_tcb);

/* 
 *  θͥ٤η׻
 *
 *  p_tcbǻꤵ륿θͥ١ʤꤹ٤͡ˤ׻롥
 */
extern uint_t	mutex_calc_priority(TCB *p_tcb);

/*
 *  ߥ塼ƥåΥå
 *
 *  p_mtxcbǻꤵߥ塼ƥåå롥å
 *  ߥ塼ƥåˡåԤ֤ΥˤϡΥ
 *  ˥ߥ塼ƥåå롥
 */
extern bool_t	mutex_release(MTXCB *p_mtxcb);

/*
 *  åƤ뤹٤ƤΥߥ塼ƥåΥå
 *
 *  p_tcbǻꤵ륿ˡ줬åƤ뤹٤ƤΥߥ塼ƥå
 *  å롥åߥ塼ƥåˡåԤ
 *  ֤ΥˤϡΥ˥ߥ塼ƥåå롥
 *
 *  δؿϡνλ˻ȤΤǤ뤿ᡤp_tcbǻꤵ
 *  륿ͥ٤ѹϹԤʤδؿ¾
 *  Υͥ٤Ѳ¹Ԥ٤Ѥ뤳Ȥ롥
 *  ᡤδؿäˡǥѥåɬפȽ̤ơɬפ
 *  ˤϥǥѥåԤʤФʤʤ
 */
extern bool_t	(*mtxhook_release_all)(TCB *p_tcb);
extern bool_t	mutex_release_all(TCB *p_tcb);

#endif /* TOPPERS_MUTEX_H */
