/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *		ͥνȽλ
 */

#include "kernel_impl.h"
#include "time_event.h"
#include <sil.h>

/*
 *  ȥ졼ޥΥǥե
 */
#ifndef LOG_KER_ENTER
#define LOG_KER_ENTER()
#endif /* LOG_KER_ENTER */

#ifndef LOG_KER_LEAVE
#define LOG_KER_LEAVE()
#endif /* LOG_KER_LEAVE */

#ifndef LOG_EXT_KER_ENTER
#define LOG_EXT_KER_ENTER()
#endif /* LOG_EXT_KER_ENTER */

#ifndef LOG_EXT_KER_LEAVE
#define LOG_EXT_KER_LEAVE(ercd)
#endif /* LOG_EXT_KER_LEAVE */

#ifdef TOPPERS_sta_ker

/*
 *  ͥư֥ե饰
 *
 *  ȥåץ롼ǡfalseʡ0ˤ˽뤳ȤԤ
 *  롥
 */
bool_t	kerflg = false;

/*
 *  ͥεư
 */
void
sta_ker(void)
{
	/*
	 *  åȰ¸ν
	 */
	target_initialize();

	/*
	 *  ƥ⥸塼ν
	 *
	 *  ।٥ȴ⥸塼¾Υ⥸塼˽
	 *  ɬפ롥
	 */
	initialize_kmm();
	initialize_tmevt();
	initialize_object();

	/*
	 *  롼μ¹
	 */ 
	call_inirtn();

	/*
	 *  ͥưγ
	 */
	kerflg = true;
	LOG_KER_ENTER();
	start_dispatch();
	assert(0);
}

#endif /* TOPPERS_sta_ker */

/*
 *  ͥνλ
 */
#ifdef TOPPERS_ext_ker

ER
ext_ker(void)
{
	SIL_PRE_LOC;

	LOG_EXT_KER_ENTER();

	/*
	 *  ߥå֤˰ܹ
	 */
	SIL_LOC_INT();

	/*
	 *  ͥưνλ
	 */
	LOG_KER_LEAVE();
	kerflg = false;

	/*
	 *  ͥνλθƽФ
	 *
	 *  󥿥ƥȤڤ괹ơexit_kernelƤӽФ
	 */
	call_exit_kernel();

	/*
	 *  ѥηٹкʤ뤳ȤϤʤϤ
	 */
	SIL_UNL_INT();
	LOG_EXT_KER_LEAVE(E_SYS);
	return(E_SYS);
}

/*
 *  ͥνλ
 */
void
exit_kernel(void)
{
	/*
	 *  λ롼μ¹
	 */
	call_terrtn();

	/*
	 *  åȰ¸νλ
	 */
	target_exit();
	assert(0);
}

#endif /* TOPPERS_ext_ker */

/*
 *  ͥγդΰδ
 *
 *  ΰƬ˳ơ줿ΰѤ
 *  ⥸塼롥
 */
#ifdef TOPPERS_kermem
#ifndef OMIT_KMM_ALLOCONLY

static void	*kmm_brk;

void
initialize_kmm(void)
{
	kmm_brk = ((char *) kmm) + kmmsz;
}

void *
kernel_malloc(SIZE size)
{
	if (((char *) kmm_brk) - ((char *) kmm) >= size) {
		kmm_brk = ((char *) kmm_brk) - size;
		return(kmm_brk);
	}
	else {
		return(NULL);
	}
}

void
kernel_free(void *ptr)
{
}

#endif /* OMIT_KMM_ALLOCONLY */
#endif /* TOPPERS_kermem */
