/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2004-2012 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  嵭Ԥϡʲ(1)(4)ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣ
 *  ѡۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *      ޤܥեȥΥ桼ޤϥɥ桼Τʤ
 *      ͳ˴Ťᤫ⡤嵭ԤTOPPERSץȤ
 *      դ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪ
 *  ФŬޤơʤݾڤԤʤޤܥեȥ
 *  ѤˤľŪޤϴŪʤ»˴ؤƤ⡤
 *  Ǥʤ
 * 
 *  $Id$
 */

/*
 *		ȥ졼˴ؤ
 *
 *  Υ󥯥롼ɥեϡtarget_config.htarget_syssvc.h
 *  ߤ饤󥯥롼ɤ롥ޤȥ졼ǽν䵭Ͽγ
 *  ϡߡȥ졼ΥפԤץफ饤󥯥롼ɤ
 *  ȤꤷƤ롥
 */

#ifndef TOPPERS_TRACE_CONFIG_H
#define TOPPERS_TRACE_CONFIG_H

/*
 *  ȥ졼ХåեΥ
 */
#ifndef TCNT_TRACE_BUFFER
#define TCNT_TRACE_BUFFER	1024
#endif /* TCNT_TRACE_BUFFER */

/*
 *  ȥ졼μˡ
 */
#ifndef TRACE_GET_TIM
#define TRACE_GET_TIM()		(current_time)
#endif /* TRACE_GET_TIM */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ȥ졼Υǡ¤
 *
 *  ƥǽΥΥǡ¤ƱΤѤ롥
 */
#include <t_syslog.h>
typedef	SYSLOG	TRACE;

/*
 *  ȥ졼ХåեȤ˥뤿Υݥ
 */
extern TRACE	trace_buffer[];		/* ȥ졼Хåե */
extern uint_t	trace_count;		/* ȥ졼ХåեΥο */
extern uint_t	trace_head;			/* ƬΥȥ졼γǼ */
extern uint_t	trace_tail;			/* Υȥ졼γǼ */
extern uint_t	trace_lost;			/* 줿ȥ졼ο */

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ȥ졼⡼ɤ
 */
#define TRACE_STOP			UINT_C(0x00)	/* ȥ졼 */
#define TRACE_RINGBUF		UINT_C(0x01)	/* 󥰥Хåե⡼ */
#define TRACE_AUTOSTOP		UINT_C(0x02)	/* ưߥ⡼ */
#define TRACE_CLEAR			UINT_C(0x04)	/* ȥ졼Υꥢ */

#ifndef TOPPERS_MACRO_ONLY

/*
 *  ȥ졼ǽν
 *
 *  ȥ졼ǽ롥롼ȤϿ뤳Ȥ
 *  ꤷƤ롥ˤ꼡ưԤ
 *
 *  TRACE_STOPΤߤǥȥ졼ϳϤʤ
 *  TRACE_RINGBUF󥰥Хåե⡼ɤǥȥ졼򳫻ϡ
 *  TRACE_AUTOSTOPưߥ⡼ɤǥȥ졼򳫻ϡ
 */
extern void	trace_initialize(intptr_t exinf);

/*
 *  ȥ졼γ
 *
 *  ȥ졼εϿ򳫻ϡߤ롥ˤ꼡ưԤ
 *
 *  TRACE_STOPȥ졼ߡ
 *  TRACE_RINGBUF󥰥Хåե⡼ɤǥȥ졼򳫻ϡ
 *  TRACE_AUTOSTOPưߥ⡼ɤǥȥ졼򳫻ϡ
 *  TRACE_CLEARȥ졼򥯥ꥢ
 */
extern ER	trace_sta_log(MODE mode);

/*
 *  ȥ졼ν
 */
extern ER	trace_wri_log(TRACE *p_trace);

/*
 *  ȥ졼ɽФ
 */
extern ER	trace_rea_log(TRACE *p_trace);

/* 
 *  ȥ졼Υסtrace_dump.c
 *
 *  ȥ졼פ롥λ롼ȤϿ뤳Ȥ
 *  Ƥ롥ȤơȤʤʸϴؿؤΥݥ󥿤Ϥ
 *  åȰ¸٥ʸϤѤˤϡtarget_putc
 *  
 */
extern void	trace_dump(intptr_t exinf);

/*
 *  ȥ졼Ϥ뤿Υ饤֥ؿ
 */
extern void	trace_write_0(uint_t type);
extern void	trace_write_1(uint_t type, intptr_t arg1);
extern void	trace_write_2(uint_t type, intptr_t arg1, intptr_t arg2);
extern void	trace_write_3(uint_t type, intptr_t arg1, intptr_t arg2,
														intptr_t arg3);

/*
 *  ȥ졼Ϥ뤿Υޥ
 */

#define trace_0(type) \
				trace_write_0(type)

#define trace_1(type, arg1) \
				trace_write_1(type, (intptr_t)(arg1))

#define trace_2(type, arg1, arg2) \
				trace_write_2(type, (intptr_t)(arg1), (intptr_t)(arg2))

#define trace_3(type, arg1, arg2, arg3) \
				trace_write_3(type, (intptr_t)(arg1), (intptr_t)(arg2), \
						(intptr_t)(arg3))

#endif /* TOPPERS_MACRO_ONLY */

/*
 *  ȥ졼ˡ
 */
#define LOG_TSKSTAT(p_tcb)		trace_2(LOG_TYPE_TSKSTAT, p_tcb, p_tcb->tstat)

#define LOG_DSP_LEAVE(p_tcb)	trace_1(LOG_TYPE_DSP|LOG_LEAVE, p_tcb)

#define LOG_SYSLOG_WRI_LOG_ENTER(prio, p_syslog) \
								trace_wri_log((TRACE *) p_syslog)

#endif /* TOPPERS_TRACE_CONFIG_H */
