class BookmarkMenu {
    constructor( bookmark_displayname_max_length , mgr ) {
	this.bookmark_displayname_max_length = bookmark_displayname_max_length
	this.bookmark_mgr = mgr
    }

    dlg(){
console.log("BookmarkMenu dlg()")
	$( '#bookmark_displayname' ).prop( 'maxlength' , Globalx.bookmark_displayname_max_length)
	$('#bookmarkDlg').dialog({
	    autoOpen: false,
	    modal: true,
	    buttons: {
		"OK": function() {
		    const part = Globalx.parts[ Globalx.index ]
		    const path = $( '#bookmark_path' ).val()
		    const displayname = $( '#bookmark_displayname' ).val()
		    Globalx.bookmarkmenu.register_bookmark(path, displayname )
		    $(this).dialog("close")},
		"Cancel": function() {
		    const part = Globalx.parts[ Globalx.index ]
		    const bookmark_cb = $( Globalx[part].bookmark_op_sel )
		    bookmark_cb.prop('checked', false)
		    $(this).dialog("close")
		}
	    }
	}) 
    }

    add_bookmark() {
	let part = Globalx.parts[ Globalx.index ]
console.log("add_bookmark part=" + part)
	$( '#bookmark_displayname' ).val( this.bookmark_mgr.get_restricted_display_name( Globalx[part].key ) )
	$( '#bookmark_path' ).val( Globalx[part].key )
	$( '#bookmarkDlg' ).dialog("open")
    }

    remove_bookmark() {
	let part = Globalx.parts[ Globalx.index ]
console.log("remove_bookmark part=" + part)
	this.bookmark_mgr.remove( part, Globalx[part].key )
	this.rebuild_bookmark_menu(part)
    }

    bookmark_op() {
	let part = Globalx.parts[ Globalx.index ]
	let bookmark_op_sel = Globalx[part].bookmark_op_sel
console.log("bookmark_op part=" + part + " bookmark_op_sel=" + bookmark_op_sel)
	if( $( bookmark_op_sel ).is(':checked') == true ){
	    this.add_bookmark()
	}
	else{
	    this.remove_bookmark()
	}
    }

    set_click_handler(part) {
	let bookmark_op_sel = Globalx[part].bookmark_op_sel

	console.log( "set_click_handler() part=" + part + " bookmark_op_sel=" + bookmark_op_sel )
	$( bookmark_op_sel ).on( 'click' , () => { 
	    console.log("bookmark_op_sel clicked")
	    this.bookmark_op() } )
    }

    register_bookmark( path, displayname ) {
	let part = Globalx.parts[ Globalx.index ]
	console.log("BookmarkMenu register_bookmark part="+part+" path="+path)
	this.bookmark_mgr.add( part, path , displayname )
	this.rebuild_bookmark_menu(part)
    }

    rebuild_bookmark_menu(part) {
	let num = Globalx.num
	let bookmark_sel = Globalx[part].bookmark_sel
console.log("BookmarkMenu rebuld_bookmark_menu num="+num+ " part="+part)
	$( bookmark_sel ).empty()

	const array = this.bookmark_mgr.get_paths(part)
console.log("BookmarkMenu rebuld_bookmark_menu array=" + array )

	let content = null
	let item = null
	array.map( ( path ) => {
	    const display_name = this.bookmark_mgr.display_name( part, path )
	    content = `<li><a href="#" >${display_name}</a></li>`;
	    console.log("BookmarkMenu rebuld_bookmark_menu content=" + content)
	    $( bookmark_sel ).append( content );
	    console.log( "bookmark_sel="+bookmark_sel)
	    item = $( bookmark_sel ).last()
	    console.log( "item=" + item )
	    item.on('click' , () => {
		console.log("BookmarkMenu rebuld_bookmark_menu bookmark_action part="+part + " path" + path )
		this.bookmark_action( part , path )
	    } )
	    console.log("BookmarkMenu rebuld_bookmark_menu path=" + path )
	})
    }

    set_globalx_item_name( part, item_name ) {
	Globalx[part].item_name = item_name
	let dl = $( Globalx[part].download_sel )
	dl.attr('download' , Globalx[part].item_name)
	dl.removeAttr('href')
    }

    bookmark_action = ( part, key ) => {
	if( key === null || key === "" ){
	    alert("illeagal key=" + key )
	    return
	}
	if(key === Globalx[part].key){
	    return
	}
	let num = Globalx.num
	let jsondata = Globalx.storagex.get_filelist( Globalx.num , part)
	Globalx[part].key = key
	Globalx[part].key_indicate_file = false;

	this.set_globalx_item_name( part, key )

	$( Globalx[part].key_sel ).val( key )
console.log("jsondata=" + jsondata)
	if( jsondata[key].length == 0 ){
	    Globalx[part].key_indicate_file = true;
	    Globalx.remotex.get_content( num, part, Globalx[part].key , (content) => {
		Globalx[part].editor.getSession().setValue( content )
		$( Globalx[part].textarea_sel ).val( content )
	    });
	}
	else{
	    Globalx[part].key_indicate_file = false
	    Globalx[part].editor.getSession().setValue( "" );
	    $( Globalx[part].textarea_sel ).val( "" );
	}
	const bookmark_cb = $( Globalx[part].bookmark_op_sel )
	bookmark_cb.prop('checked', true)

	$( Globalx[part].menu_sel ).empty()

	this.make_menu_item_list(jsondata, Globalx[part].key)
    }
}
