let Globalx = {};
let GlobalxInitValue = {
    editor: null,
    key_indicate_file: false,
    key: '/'
};

function main() {
    restore_info_to_globalx()

    editor_func("data");
    make_ul_for_menu('data' , '#data-side')
    menux( "data" )
    
    editor_func("setting");
    make_ul_for_menu("setting" , '#setting-side')
    
    editor_func("output");
    make_ul_for_menu("output" , '#output-side')

    tab_init()
    topmenu_init()

    rebuild_bookmark_menu("data")

    // LocalStorageにまだ保存していない場合を想定して、ここで保存しておく
    console.log("call save_info_from_globalx()")
    save_info_from_globalx()

    part = "data"
    $('#down-download').on('click', {part: part}, handleDownload)
    $( Globalx['data'].textarea_sel ).val("");
    $( '#bookmark_displayname' ).prop( 'maxlength' , Globalx[part].bookmark_displayname_max_length)
    $('#bookmarkDlg').dialog({
	autoOpen: false,
	modal: true,
	buttons: {
	    "OK": function() {
		part = Globalx.parts[ Globalx.index ]
		path = $( '#bookmark_path' ).val()
		displayname = $( '#bookmark_displayname' ).val()
		register_bookmark_( part , path, displayname )
		$(this).dialog("close")},
	    "Cancel": function() {
		bookmark_cb.prop('checked', false)
		$(this).dialog("close")
	    }
	}
    }) 
}

function init_globalx() {
    Globalx.num = 0;
    Globalx.index = 0;
    Globalx.parts = ["data", "output", "setting"]
    
    Globalx.parts.map( function( part ){
	console.log("init_globalx part=" + part )
	set_globalx_editor(part)
    } )
}

function set_globalx_editor(part) {
      Globalx[part] = {
	  editor_id: `${part}-editor`,
	  editor: null,
	  textarea_sel: `textarea[name=${part}-editor-t`,
/**/
	  menu_id: `${part}-menu2`,
          bookmark_id: `${part}-bookmark`,
          bookmark_op_id: `${part}-bookmark_op`,
          item_name: "",
/**/
	  bookmarks: [],
	  bookmark_displayname_max_length: 18,
          key_indicate_file: false,
	  key: '/',
	  key_sel: `#${part}-filelist_key`,
          download_sel: `#${part}-download_sel`
      }
      Globalx[part].menu_sel = `#${Globalx[part].menu_id}`
      Globalx[part].bookmark_sel = `#${Globalx[part].bookmark_id}`
      Globalx[part].bookmark_op_sel = `#${Globalx[part].bookmark_op_id}`
      Globalx[part].bookmark_mgr = new BookmarkMgr( Globalx[part].bookmark_displayname_max_length )

}

function editor_func(part) {
      let editor = ace.edit( Globalx[part].editor_id )
      editor.setTheme("ace/theme/monokai");
      editor.setFontSize(14);
      editor.getSession().setMode("ace/mode/markdown");
      editor.getSession().setUseWrapMode(true);
      editor.getSession().setTabSize(2);
      Globalx[part].editor = editor;
      let textarea = $( Globalx[part].textarea_sel );
      Globalx[part].textarea = textarea;
      editor.getSession().on("change", function () {
          Globalx[part].textarea.val(editor.getSession().getValue());
      });
}

