function make_ul_for_menu( part, sel ) {
    let content = `<ul id="${Globalx[part].menu_id}"></ul>`
    let v = $(sel).append( content )
}

function set_globalx_item_name( part, item_name ) {
    Globalx[part].item_name = item_name
    let dl = $( '#download' )
    dl.attr('download' , Globalx[part].item_name)
    dl.removeAttr('href')
}

function menu_action( part, item_name , up_flag = false ) {
    let realData = get_filelist( Globalx.num )
    Globalx[part].key_indicate_file = false;
    if( up_flag ){
	set_globalx_item_name(part, "")
	Globalx[part].editor.getSession().setValue( "" );
	$( Globalx[part].textarea_sel ).val( "" );
	if( Globalx[part].key != '/' ){
	    let array = Globalx[part].key.split("/")
	    array.pop()
	    if( array.length > 1 ){
		Globalx[part].key_type = false;
		set_globalx_item_name( part, array[array.length - 1] )

		Globalx[part].key = array.join('/')
		$( Globalx[part].menu_sel ).empty()
	    }
	    else {
		Globalx[part].key = '/'
		set_globalx_item_name( part, "" )
	    }
	}
    }
    else{
	if( Globalx[part].key == '/' ){
	    Globalx[part].key = Globalx[part].key + item_name
	}
	else{
	    Globalx[part].key = Globalx[part].key + '/' + item_name
	}
    }
    set_globalx_item_name(part, item_name)

    const bookmark_cb = $( Globalx[part].bookmark_op_sel )
    if( Globalx[part].bookmarks.indexOf( Globalx[part].key ) >= 0 ){
	bookmark_cb.prop('checked', true)
    }
    else{
	bookmark_cb.prop('checked', false)
    }

    $( Globalx[part].key_sel ).val( Globalx[part].key )
    $( Globalx[part].menu_sel ).empty()

    make_menu_item_list(part, realData)

    if( realData[Globalx[part].key].length == 0 ){
	Globalx[part].key_indicate_file = true;
	get_content( Globalx[part].key , function(content) {
	    Globalx[part].editor.getSession().setValue( content );
	    $( Globalx[part].textarea_sel ).val( content );
	});
    }
} 

function make_menu_item_list( part, realData ) {
    let content = null
    let ary = realData[ Globalx[part].key ]

    let name = '..(Up)'
    content = `<li class="ui-menu-item"><div class="ui-menu-item-wrapper hasmenu" onclick="menu_action( '${part}', '${name}', true)">${name}</div></li>`;
    $( Globalx[part].menu_sel ).append(content);

    ary.map( function( item_name ){
	content = `<li class="ui-menu-item"><div class="ui-menu-item-wrapper hasmenu" onclick="menu_action( '${part}', '${item_name}' , false)">${item_name}</div></li>`;
	$( Globalx[part].menu_sel ).append(content);
    })
}

async function get_filelist_async( num )
{
     let realData = get_filelist( Globalx.num )
     if( realData === undefined ){
	await get_filelist_from_remote()
	realData = get_filelist( Globalx.num )
    }

    return realData
}

function menux( part ) {
    get_filelist_async( Globalx.num ).then( (data) => {
	make_menu_item_list( part, data )
	$( Globalx[part].menu_sel ).menu({
	    classes: {
		"ui-menu": "highlight"
	    }
	})
    })
}

function contextmenux0( menu_sel ) {
    $( menu_sel ).contextmenu({
	delegate: ".hasmenu",
	menu: [
	    {title: "Copy", cmd: "copy", uiIcon: "ui-icon-copy"},
	    {title: "----"},
	    {title: "More", childern: [
		{title: "Sub 1", cmd: "sub1"},
		{title: "Sub 2", cmd: "sub1"}
	    ]}
	],
	select: function(event, ui) {
	    alert("select " + ui.cmd + " on " + ui.target.text());
	}
    });
}

function bookmark_op(part) {
    if( $( Globalx[part].bookmark_op_sel ).is(':checked') == true ){
	console.log( Globalx[part].key +" add_bookmark" )
	add_bookmark(part)
    }
    else{
	console.log( Globalx[part].key +" remove_bookmark")
	remove_bookmark(part)
    }
}

function add_bookmark( part ) {
    Globalx[part].bookmark_mgr.add( Globalx[part].key )
    rebuild_bookmark_menu( part )
    $( '#bookmark_displayname' ).val( Globalx[part].bookmark_mgr.get_restricted_display_name( Globalx[part].key ) )
    $( '#bookmark_path' ).val( Globalx[part].key )
    $('#bookmarkDlg').dialog("open")
    
}

function remove_bookmark(part) {
    Globalx[part].bookmark_mgr.remove( Globalx[part].key )
    rebuild_bookmark_menu(part)
}

function rebuild_bookmark_menu(part) {
    $( Globalx[part].bookmark_sel ).empty()

    const mgr = Globalx[part].bookmark_mgr
    const array = mgr.get_paths()

    array.map( function( path ){
	const display_name = mgr.display_name( path )
	content = `<li><a href="#" onclick="bookmark_action( '${part}' , '${path}' )">${display_name}</a></li>`;
	$( Globalx[part].bookmark_sel ).append(content);
    })
}

function bookmark_action( part, key ) {
    if( key === null || key === "" ){
	alert("illeagal key=" + key )
	return
    }
    let realData = get_filelist( Globalx.num )
    Globalx[part].key = key
    Globalx[part].key_indicate_file = false;

    set_globalx_item_name( part, key )
    $( Globalx[part].key_sel ).val( key )

    if( realData[Globalx[part].key].length == 0 ){
	Globalx[part].key_indicate_file = true;
	get_content( Globalx[part].key , function(content) {
	    Globalx[part].editor.getSession().setValue( content );
	    $( Globalx[part].textarea_sel ).val( content );
	});
    }
    const bookmark_cb = $( Globalx[part].bookmark_op_sel )
    bookmark_cb.prop('checked', true)
}
