/*
 *   Copyright (C) 2008-2017 by TOPPERS Project
 *
 *  上記著作権者は，以下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェ
 *  ア（本ソフトウェアを改変したものを含む．以下同じ）を使用・複製・改
 *  変・再配布（以下，利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *      また，本ソフトウェアのユーザまたはエンドユーザからのいかなる理
 *      由に基づく請求からも，上記著作権者およびTOPPERSプロジェクトを
 *      免責すること．
 * 
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，特定の使用目的
 *  に対する適合性も含めて，いかなる保証も行わない．また，本ソフトウェ
 *  アの利用により直接的または間接的に生じたいかなる損害に関しても，そ
 *  の責任を負わない．
 * 
 *  @(#) $Id: nTECSInfo_tStructTypeInfo.c 2656 2017-06-24 11:57:31Z okuma-top $
 */

/* #[<PREAMBLE>]#
 * #[<...>]# から #[</...>]# で囲まれたコメントは編集しないでください
 * tecsmerge によるマージに使用されます
 *
 * 属性アクセスマクロ #_CAAM_#
 * name             char_t*          ATTR_name       
 * typeKind         int8_t           ATTR_typeKind   
 * size             uint32_t         ATTR_size       
 * b_const          bool_t           ATTR_b_const    
 * b_volatile       bool_t           ATTR_b_volatile 
 *
 * 呼び口関数 #_TCPF_#
 * call port: cTypeInfo signature: nTECSInfo_sTypeInfo context:task
 *   ER             cTypeInfo_getName( subscript, char_t* name, int_t max_len );
 *   uint16_t       cTypeInfo_getNameLength( subscript );
 *   uint32_t       cTypeInfo_getSize( subscript );
 *   int8_t         cTypeInfo_getKind( subscript );
 *   uint32_t       cTypeInfo_getNType( subscript );
 *   ER             cTypeInfo_getTypeInfo( subscript, uint32_t ith, Descriptor( nTECSInfo_sTypeInfo )* desc );
 *       subscript:  0...(NCP_cTypeInfo-1)
 *   [ref_desc]
 *      Descriptor( nTECSInfo_sTypeInfo ) cTypeInfo_refer_to_descriptor( int_t subscript );
 *      Descriptor( nTECSInfo_sTypeInfo ) cTypeInfo_ref_desc( int_t subscript )      (same as above; abbreviated version);
 *
 * #[</PREAMBLE>]# */

/* プロトタイプ宣言や変数の定義をここに書きます #_PAC_# */
#include "nTECSInfo_tStructTypeInfo_tecsgen.h"

#ifndef E_OK
#define	E_OK	0		/* success */
#define	E_ID	(-18)	/* illegal ID */
#endif

/* 受け口関数 #_TEPF_# */
/* #[<ENTRY_PORT>]# eTypeInfo
 * entry port: eTypeInfo
 * signature:  nTECSInfo_sTypeInfo
 * context:    task
 * #[</ENTRY_PORT>]# */

/* #[<ENTRY_FUNC>]# eTypeInfo_getName
 * name:         eTypeInfo_getName
 * global_name:  nTECSInfo_tStructTypeInfo_eTypeInfo_getName
 * oneway:       false
 * #[</ENTRY_FUNC>]# */
ER
eTypeInfo_getName(CELLIDX idx, char_t* name, int_t max_len)
{
	ER		ercd = E_OK;
	CELLCB	*p_cellcb;
	if (VALID_IDX(idx)) {
		p_cellcb = GET_CELLCB(idx);
	}
	else {
		return(E_ID);
	} /* end if VALID_IDX(idx) */

	/* ここに処理本体を記述します #_TEFB_# */
	name[ max_len - 1 ] = '\0';
	strncpy( name, ATTR_name, max_len );
  if( name[ max_len - 1 ] ){
      name[ max_len - 1 ] = '\0';
      ercd = E_NOMEM;
  }

	return(ercd);
}

/* #[<ENTRY_FUNC>]# eTypeInfo_getNameLength
 * name:         eTypeInfo_getNameLength
 * global_name:  nTECSInfo_tStructTypeInfo_eTypeInfo_getNameLength
 * oneway:       false
 * #[</ENTRY_FUNC>]# */
uint16_t
eTypeInfo_getNameLength(CELLIDX idx)
{
	CELLCB	*p_cellcb;
	if (VALID_IDX(idx)) {
		p_cellcb = GET_CELLCB(idx);
	}
	else {
		/* エラー処理コードをここに記述します */
	} /* end if VALID_IDX(idx) */

	/* ここに処理本体を記述します #_TEFB_# */
	return strlen( ATTR_name ) + 1;
      /* 終端文字 (NULL) を含む */
}

/* #[<ENTRY_FUNC>]# eTypeInfo_getSize
 * name:         eTypeInfo_getSize
 * global_name:  nTECSInfo_tStructTypeInfo_eTypeInfo_getSize
 * oneway:       false
 * #[</ENTRY_FUNC>]# */
uint32_t
eTypeInfo_getSize(CELLIDX idx)
{
	CELLCB	*p_cellcb;
	if (VALID_IDX(idx)) {
		p_cellcb = GET_CELLCB(idx);
	}
	else {
		/* エラー処理コードをここに記述します */
	} /* end if VALID_IDX(idx) */

	/* ここに処理本体を記述します #_TEFB_# */
  return ATTR_size;
}

/* #[<ENTRY_FUNC>]# eTypeInfo_getKind
 * name:         eTypeInfo_getKind
 * global_name:  nTECSInfo_tStructTypeInfo_eTypeInfo_getKind
 * oneway:       false
 * #[</ENTRY_FUNC>]# */
int8_t
eTypeInfo_getKind(CELLIDX idx)
{
	CELLCB	*p_cellcb;
	if (VALID_IDX(idx)) {
		p_cellcb = GET_CELLCB(idx);
	}
	else {
		/* エラー処理コードをここに記述します */
	} /* end if VALID_IDX(idx) */

	/* ここに処理本体を記述します #_TEFB_# */
  return TECSTypeKind_StructType;
}

/* #[<ENTRY_FUNC>]# eTypeInfo_getNType
 * name:         eTypeInfo_getNType
 * global_name:  nTECSInfo_tStructTypeInfo_eTypeInfo_getNType
 * oneway:       false
 * #[</ENTRY_FUNC>]# */
uint32_t
eTypeInfo_getNType(CELLIDX idx)
{
	CELLCB	*p_cellcb;
	if (VALID_IDX(idx)) {
		p_cellcb = GET_CELLCB(idx);
	}
	else {
		/* エラー処理コードをここに記述します */
	} /* end if VALID_IDX(idx) */

	/* ここに処理本体を記述します #_TEFB_# */
  return NCP_cTypeInfo;
}

/* #[<ENTRY_FUNC>]# eTypeInfo_getTypeInfo
 * name:         eTypeInfo_getTypeInfo
 * global_name:  nTECSInfo_tStructTypeInfo_eTypeInfo_getTypeInfo
 * oneway:       false
 * #[</ENTRY_FUNC>]# */
ER
eTypeInfo_getTypeInfo(CELLIDX idx, uint32_t ith, Descriptor( nTECSInfo_sTypeInfo )* desc)
{
	CELLCB	*p_cellcb;
	if (VALID_IDX(idx)) {
		p_cellcb = GET_CELLCB(idx);
	}
	else {
		/* エラー処理コードをここに記述します */
	} /* end if VALID_IDX(idx) */

	/* ここに処理本体を記述します #_TEFB_# */
  *desc = cTypeInfo_refer_to_descriptor( ith );
}

/* #[<POSTAMBLE>]#
 *   これより下に非受け口関数を書きます
 * #[</POSTAMBLE>]#*/
