class Storagex {
    constructor () {
	this._globalStorage = {}
	this._items = ["num", "index", "parts"]
    }

    ensure_data_structure ( item , parts ) {
	parts.map( (part) => {
	    if( item[part] === undefined ){
		item[part] = {}
	    }
	} )
    }

    save_as_info_from_globalx() {
	this.save_as_info_from_globalx_with_items(this._items)
    }

    save_as_info_from_globalx_with_items(items){
	let info = {}

	this.copy_object( info, Globalx, items )
	Globalx.parts.map( (part) => {
	    this.save_as_info_from_globalx_part(part , info)
	} )

	this.save_as_info_to_local_storage(info)
    }

    save_as_info_to_local_storage(obj){
	this.save_to_local_storage("info" , obj)
    }

    save_as_info_from_globalx_part(part , info){
	info[part] = {}
	this.copy_obj_with_part(info, Globalx, part)
	
	info[part].bookmark_mgr = this.convert_to_plain_object_from_bookmark_mgr(Globalx[part].bookmark_mgr)
    }

    save_to_local_storage(key , obj) {
	this._globalStorage[key] = obj
	localStorage.setItem(key , JSON.stringify(obj) )
    }

    change_cache( obj , num , part ){
	const key = `${num}/${part}`
	this._globalStorage[key] = obj
	localStorage.setItem(key , JSON.stringify(this._globalStorage[key]) )
    }

    convert_to_array_from_bookmark_mgr(mgr){
	return {
	    paths: mgr.get_paths(),
	    items: mgr_to_array(mgr),
	    max_display_name_length: mgr.max_display_name_length()
	}
    }

    convert_to_plain_object_from_bookmark_mgr(mgr){
	const paths = mgr.get_paths()
	const new_bk_items = paths.map( ( path ) => {
	    let ret = {
		path: "",
		display_name: ""
	    }
	    item = mgr.get(path)
	    if( item != null ){
		ret.path = path
		ret.display_name = item.display_name
	    }
	    return ret
	} )
	
	return {
	    max_display_name_length: mgr.max_display_name_length,
	    items: new_bk_items
	}
    }

    copy_obj_with_part(to_obj, from_obj, part){
	const items = ["editor_id", "textarea_sel" , "menu_id", "bookmark_id", "bookmark_op_id", "item_name", "bookmarks", "key_sel", "download_sel", "menu_sel", "bookmark_sel", "bookmark_op_sel", "bookmark_mgr" ]
	const init_value_items = ["editor", "key_indicate_file", "key"]
	
	if( to_obj[part] === undefined ){
	    to_obj[part] = {}
	}
	this.copy_object( to_obj[part], from_obj[part], items )
	this.copy_object( to_obj[part], GlobalxInitValue, init_value_items )
    }

    copy_object( to_obj, from_obj, items ){
	let x = null
	items.map( (item) => {
	    x = from_obj[item]
	    to_obj[item] = x
	} )
    }

    restore_info(){
	const item_name = "info"
	return this.restore_from_localstorage(item_name)
    }

    restore_from_localstorage(num, part= null){
	let key = null
	let ret = null
	if( part === null ){
	    key = num
	}
	else{
	    key = `${num}/${part}`
	}
	const str = localStorage.getItem(key)
	if( str ){
	    ret = this._globalStorage[key] = JSON.parse(str)
//	    console.log("rfl 1 key=" + key + " str=" + str)
	}
	else{
	    if( this._globalStorage[key] !== undefined ){
		delete this._globalStorage[key]
	    }
	    ret = this._globalStorage[key]
	    console.log("rfl 2 key=" + key + " undefined")
	}

	return ret
    }

    restore_globalx_from_info(){
	let need_to_save = false
	const info = this.restore_info()
	if( info !== undefined && info !== null ){
	    this.restore_info_to_globalx_with_items(info, this._items)
	}
	else{
	    need_to_save = true
	}

	return need_to_save
    }

    convert_to_bookmark_mgr_from_plain_object(mgr) {
	let new_mgr = new BookmarkMgr( mgr.max_display_name_length )
	
	const bk_items = mgr.items
	bk_items.map( (bk_item) => {
	    return new_mgr.add( bk_item.path , bk_item.display_name)
	})
	return new_mgr
    }

    restore_info_to_globalx_with_items(info, items){
	this.copy_object( Globalx, info, items )
	
	info.parts.map( (part) => {
	    this.restore_globalx_from_info_part(info , part)
	} )
    }

    restore_globalx_from_info_part(info , part){
	info[part].bookmark_mgr = this.convert_to_bookmark_mgr_from_plain_object(info[part].bookmark_mgr)
	this.copy_obj_with_part(Globalx, info, part)
    }

    get_filelist(num, part) {
	return this.restore_from_localstorage(num, part)
    }



    reset_info = () => {
	let item_name = 'info'
	reset_localstorage(item_name)
    }
    
    reset_localstorage(item_name){
	delete this._globalStorage[item_name]
	localStorage.removeItem(item_name)
    }

    clear_localstorage = () => {
	let keys = Object.keys(this._globalStorage)
	keys.map( (v) => { delete this._globalStorage[v] } )
	
	localStorage.clear()
    }
    show_localstorage() {
	window.open('local_storage.html', '_blank')
    }

    show_globalx() {
	localStorage.setItem('globalx' , _globalStorage[0] )
    }
}

