let _globalStorage = {}

const _items = ["num", "index", "parts"]

function storage_test(){
    console.log(_items);
}

function save_info_from_globalx(){
    save_info_from_globalx_with_items(_items)
}

function convert_to_array_from_bookmark_mgr(mgr){
	return {
	    paths: mgr.get_paths(),
	    items: mgr_to_array(mgr),
	    max_display_name_length: mgr.max_display_name_length()
	}
}

function save_info_from_globalx_with_items(items){
    let info = {}

    copy_object( info, Globalx, items )
    /*	
	info.num = Globalx.num
	info.index = Globalx.index
	info.parts = Globalx.parts
    */
    Globalx.parts.map( function (part) {
	save_info_from_globalx_part(info , part)
    } )

    save_info_to_local_storage(info)
}
function convert_to_plain_object_from_bookmark_mgr(mgr){
//    console.log( "mgr=" + mgr )
//    console.log( "mgr.items()=" + mgr.items )
    const paths = mgr.get_paths()
    const new_bk_items = paths.map( function( path ){
	let ret = {
	    path: "",
	    display_name: ""
	}
	item = mgr.get(path)
	if( item != null ){
	    ret.path = path
	    ret.display_name = item.display_name
	}
	return ret
    } )

    return {
	max_display_name_length: mgr.max_display_name_length,
	items: new_bk_items
    }
}

function save_info_from_globalx_part(info, part){
    info[part] = {}
    copy_obj_with_part(info, Globalx, part)

    info[part].bookmark_mgr = convert_to_plain_object_from_bookmark_mgr(Globalx[part].bookmark_mgr)
}

function copy_obj_with_part(to_obj, from_obj, part){
/*    const items = ["editor_id", "editor", "textarea_sel" , "menu_id", "bookmark_id", "bookmark_op_id", "item_name", "bookmarks", "bookmark_displayname_max_length", "key_indicate_file", "key", "key_sel", "download_sel", "menu_sel", "bookmark_sel", "bookmark_op_sel", "bookmark_mgr" ]*/
    const items = ["editor_id", "textarea_sel" , "menu_id", "bookmark_id", "bookmark_op_id", "item_name", "bookmarks", "bookmark_displayname_max_length", "key_sel", "download_sel", "menu_sel", "bookmark_sel", "bookmark_op_sel", "bookmark_mgr" ]
    const init_value_items = ["editor", "key_indicate_file", "key"]

    if( to_obj[part] === undefined ){
	to_obj[part] = {}
    }
    copy_object( to_obj[part], from_obj[part], items )
    copy_object( to_obj[part], GlobalxInitValue, init_value_items )
}

function copy_object( to_obj, from_obj, items ){
    let x = null
    items.map( function(item) {
	x = from_obj[item]
	to_obj[item] = x
    } )
}

function restore_info_to_globalx(){
    const info = restore_info()
    if( info === undefined ){
	console.log("call init_globalx()")
	init_globalx()
    }
    else {
	console.log("call restore_info_to_globalx_with_items")
	restore_info_to_globalx_with_items(info, _items)
    }
}

function convert_to_bookmark_mgr_from_plain_object(mgr) {
    let new_mgr = new BookmarkMgr( mgr.max_display_name_length )
    
    const bk_items = mgr.items
    bk_items.map( function(bk_item) {
	return new_mgr.add( bk_item.path , bk_item.display_name)
    })
    return new_mgr
}

function restore_info_to_globalx_with_items(info, items){
    
    copy_object( Globalx, info, items )

    info.parts.map( function (part) {
	restore_info_to_globalx_part(info , part)
    } )
}

function restore_info_to_globalx_part(info , part){
    info[part].bookmark_mgr = convert_to_bookmark_mgr_from_plain_object(info[part].bookmark_mgr)
    copy_obj_with_part(Globalx, info, part)
}

function save_info_to_local_storage(info){
    _globalStorage["info"] = info
    save_to_local_storage(JSON.stringify(info), "info")
}

function save_filelist_to_local_storage(text , num){
    let num_s = num + ''
    save_to_local_storage(text, key)
}

function save_to_local_storage(str, key) {
    _globalStorage[key] = str
    localStorage.setItem(key , str)
}

function get_filelist(num) {
    let num_s = num + ''
    return restore_from_localstorage(num_s)
}


function restore_info(){
    const item_name = "info"
    return restore_from_localstorage(item_name)
}

function restore_from_localstorage(item_name){
   if( _globalStorage[item_name] === undefined ){
	oldData = localStorage.getItem(item_name)
	if( oldData ){
	    _globalStorage[item_name] = JSON.parse(oldData)
	}
    }
    return _globalStorage[item_name]
}

function reset_info(){
    let item_name = 'info'
    reset_localstorage(item_name)
}

function reset_localstorage(item_name){
    delete _globalStorage[item_name]
    localStorage.removeItem(item_name)
}

function clear_localstorage(){
    let keys = Object.keys(_globalStorage)
    keys.map( (v) => { delete _globalStorage[v] } )

    localStorage.clear()
}
