<?php

namespace ns;

class PathItem {
    public $name = NULL;
    public $hier = NULL;
    public $id = NULL;
    protected $parent = NULL;
    protected $children = array();
    protected $file_path = NULL;
    static $inst_count = 0;

    function __construct($name, $hier, $file_path = NULL , $parent = NULL){
        $this->name = $name;
        $this->hier = $hier;
        $this->file_path = $file_path;
        $this->parent = $parent;
        $this->id = PathItem::$inst_count++;
    }

    public function get_name(){
        return $this->name;
    }

    public function get_children(){
        return $this->children;
    }

    public function set_parent($parent){
        if( $this->parent == NULL ){
            $this->parent = $parent;
            $this->parent->add_child($this);
        }
    }

    public function add_child($child){
        if( !array_search($child,  $this->children, TRUE) ){
            array_push($this->children, $child);
        }
    }

    public function dump(){
        echo "id=" . $this->id . "\n";
        echo "name=" . $this->name . "\n";
        echo "hier=" . $this->hier . "\n";
        echo "filepath=" . $this->file_path . "\n";
    }

    public function dump_children(){
        foreach($this->children as $item){
            echo "child id=" . $item->id . "\n";
            echo "child name=" . $item->name . "\n";
            echo "child hier=" . $item->hier . "\n";
        }
        echo "\n";
    }
}

?>
