let Globalx = {};
let GlobalxInitValue = {
    editor: null,
    key_indicate_file: false,
    key: '/'
};

function init_globalx_storagex() {
    Globalx.storagex = new Storagex();
}

function init_globalx() {
    Globalx.num = 0;
    Globalx.index = 0;
    Globalx.parts = ["data", "output", "setting"]
    Globalx.bookmark_displayname_max_length = 18

    tab_init()
    topmenu_init()
    Globalx.remotex = new Remotex('php/content.php')
}

function menu_action(part, item_name , up_flag = false) {
    //console.log("menu_action 1")
    Globalx[part].sidemenu.menu_action(item_name , up_flag)
    //console.log("menu_action 2")
}

function main() {
    init_globalx_storagex()

    let need_to_save = Globalx.storagex.restore_globalx_from_info()
    init_globalx()

    Globalx.parts.map( ( part ) => {
	set_globalx_editor(part)
	Globalx[ part ].bookmarkmenu = new BookmarkMenu( Globalx.num, part )
	Globalx[ part ].sidemenu = new SideMenu( Globalx.num, part )
	Globalx[ part ].sidemenu.setup(`#${part}-side`)
	Globalx[ part ].bookmarkmenu.set_click_handler()
	Globalx[ part ].bookmarkmenu.rebuild_bookmark_menu(part)

	$( Globalx[ part ].download_sel ).on('click', {num: Globalx.num, part: part}, handleDownload)
	$( Globalx[ part ].textarea_sel ).val("");
    } )
/*
    Globalx.parts.map( (part) => {
	Globalx[ part ].sidemenu.setup(`#${part}-side`)
	Globalx[ part ].bookmarkmenu.rebuild_bookmark_menu(part)

	$( Globalx[part].download_sel ).on('click', {num: Globalx.num, part: part}, handleDownload)
	$( Globalx[part].textarea_sel ).val("");
    }
  */  
    if( need_to_save ){
	// LocalStorageにまだ保存していない場合、ここで保存しておく
	//console.log("call save_as_info_from_globalx()")
	Globalx.storagex.save_as_info_from_globalx( (data) => { console.log( "data=" + data ) } )
    }

    let part = "data"
    $( '#bookmark_displayname' ).prop( 'maxlength' , Globalx.bookmark_displayname_max_length)
    $('#bookmarkDlg').dialog({
	autoOpen: false,
	modal: true,
	buttons: {
	    "OK": function() {
		part = Globalx.parts[ Globalx.index ]
		path = $( '#bookmark_path' ).val()
		displayname = $( '#bookmark_displayname' ).val()
		register_bookmark_( part , path, displayname )
		$(this).dialog("close")},
	    "Cancel": function() {
		bookmark_cb.prop('checked', false)
		$(this).dialog("close")
	    }
	}
    }) 
}


function set_globalx_editor(part) {
      Globalx[part] = {
	  editor_id: `${part}-editor`,
	  editor: null,
	  textarea_sel: `textarea[name=${part}-editor-t`,
/**/
	  menu_id: `${part}-menu2`,
          bookmark_id: `${part}-bookmark`,
          bookmark_op_id: `${part}-bookmark_op`,
          item_name: "",
/**/
	  bookmarks: [],
          key_indicate_file: false,
	  key: '/',
	  key_sel: `#${part}-filelist_key`,
          download_sel: `#${part}-down-download`
      }
      editor_config(part);

      Globalx[part].menu_sel = `#${Globalx[part].menu_id}`
      Globalx[part].bookmark_sel = `#${Globalx[part].bookmark_id}`
      Globalx[part].bookmark_op_sel = `#${Globalx[part].bookmark_op_id}`
      Globalx[part].bookmark_mgr = new BookmarkMgr( Globalx.bookmark_displayname_max_length )
}

function editor_config(part) {
      let editor = ace.edit( Globalx[part].editor_id )
      editor.setTheme("ace/theme/monokai");
      editor.setFontSize(14);
      editor.getSession().setMode("ace/mode/markdown");
      editor.getSession().setUseWrapMode(true);
      editor.getSession().setTabSize(2);
      Globalx[part].editor = editor;
      let textarea = $( Globalx[part].textarea_sel );
      Globalx[part].textarea = textarea;
      editor.getSession().on("change", function () {
          Globalx[part].textarea.val(editor.getSession().getValue());
      });
}
