//"php/content.php"
class Remotex {
    constructor( filename ){
	this.filename = filename
//	this.num = num
//	this.part = part
    }

    make_url_params( arrayx ){
	let params = new URLSearchParams();
	arrayx.reduce(function(acc, element, index, array) {
	    acc.append(element[0], element[1]);
	    return acc;
	}, params)
	return params;
    }

    async get_filelist_from_remote( num, part, func ) {
console.log("remotex get_filelist_from_remote num=" + num + " part=" + part )
	let param_array = [['cmd', 'get_filelistx'], ['num', num ], ['part', part ]]
	await this.fetchx( this.filename , param_array, func )
    }

    async update_filelist( num, part, func ) {
console.log("remotex update_filelist num=" + num + " part=" + part )
	let param_array = [['cmd', 'update_filelistx'], ['num', num ], ['part', part ]]
	await this.fetchx( this.filename , param_array, func )
    }

    async get_content(num, part, path , func) {
console.log("remotex get_content num=" + num + " part=" + part )
	console.log("part=" + part)
	let param_array = [['cmd', 'get_content'], ['num', num ], ['part', part ], ['path', path]]
	await this.fetchx( this.filename , param_array, func )
    }

    async fetchx( filename, param_array, func) {
	let params = this.make_url_params( param_array )
	fetch(`${filename}?${params}`)
	    .then((response) => response.text())
	    .then((text) => { console.log(func) ; func(text)})
	    .catch((error) => console.log(error));
    }

    handleDownload(e) {
	let dl = document.getElementById("data-down-download")

	if( Globalx[ e.data.part ].key_indicate_file === true ){
	    this.get_content( e.data.num, e.data.part , Globalx[ e.data.part ].key , (content) => {
		let blob = new Blob([ content ], { "type" : "text/plain" });

		if (window.navigator.msSaveBlob) { 
		    window.navigator.msSaveBlob(blob, Globalx[ e.data.part ].item_name); 
		    
		    // msSaveOrOpenBlobの場合はファイルを保存せずに開ける
		    window.navigator.msSaveOrOpenBlob(blob, Globalx[ e.data.part ].item_name); 
		} else {
		    dl.download = Globalx[ e.data.part ].item_name
		    dl.href = window.URL.createObjectURL(blob);
		}
	    })
	}
	else{
	    e.preventDefault()
	    dl.href = ""
	    dl.download = ""
	}
    }
}

function handleDownload(e) {
    Globalx.remotex.handleDownload(e)
}
