function upload_to_host(part) {
    if( Globalx[part].key_indicate_file === true ){
	let textarea = $( Globalx[part].textarea_sel )
	upload_content(textarea.val(), Globalx[part].key, Globalx.num)
    }
}

function upload_content(content, path, num) {
    let form = document.createElement('form');
    let req_content = document.createElement('input');
    let req_path = document.createElement('input');
    let req_cmd = document.createElement('input');
    let req_num = document.createElement('input');

    document.body.appendChild(form);
    req_content.type = 'hidden';
    req_content.name = 'mytext';
    req_content.value = content;
    
    req_path.type = 'hidden';
    req_path.name = 'path';
    req_path.value = path;
    
    req_cmd.type = 'hidden';
    req_cmd.name = 'cmd';
    req_cmd.value = 'upload_content';
    
    req_num.type = 'hidden';
    req_num.name = 'num';
    req_num.value = num + '';
    
    form.appendChild(req_content);
    form.appendChild(req_path);
    form.appendChild(req_cmd);
    form.appendChild(req_num);
    
    // FormDataオブジェクトを作成する
    var form_data = new FormData(form);

    fetch('php/content.php', {
	method: 'POST',
	mode: 'same-origin', /* 'no-cors' 'cors' 'same-origin' */
	body: form_data
    })
    .then((response) => response.text())
    .then((data) => console.log(data))
    .catch((error) => console.log(error));
}

function make_url_params( arrayx ){
      let params = new URLSearchParams();
      arrayx.reduce(function(acc, element, index, array) {
	  acc.append(element[0], element[1]);
	  return acc;
      }, params)
      return params;
}

function get_filelist_from_remote() {
    let param_array = [['cmd', 'get_filelist'], ['num', Globalx.num ]];
    let params = make_url_params( param_array );
    let filename = "php/content.php"
    fetch(`${filename}?${params}`)
    .then((response) => response.text())
    .then((str) => save_filelist_to_local_storage(str, num))
    .catch((error) => console.log(error));
}

function update_filelist() {
    let param_array = [['cmd', 'update_filelist'], ['num', Globalx.num ]];
    let params = make_url_params( param_array );
    let filename = "php/content.php"
    fetch(`${filename}?${params}`)
    .then((response) => response.text())
    .then((text) => save_filelist_to_local_storage(text, num))
    .catch((error) => console.log(error));
}

function get_content(path , func) {
    let param_array = [['cmd', 'get_content'], ['num', Globalx.num ], ['path', path]];
    let params = make_url_params( param_array );
    let filename = "php/content.php"
    fetch(`${filename}?${params}`)
    .then((response) => response.text())
    .then((text) => {func(text)})
    .catch((error) => console.log(error));
}

function handleDownload(e) {
    let dl = document.getElementById("down-download")
    if( Globalx[ e.data.part ].key_indicate_file === true ){

	get_content( Globalx[ e.data.part ].key , function(content) {
	    let blob = new Blob([ content ], { "type" : "text/plain" });

	    if (window.navigator.msSaveBlob) { 
		window.navigator.msSaveBlob(blob, Globalx[ e.data.part ].item_name); 
		
		// msSaveOrOpenBlobの場合はファイルを保存せずに開ける
		window.navigator.msSaveOrOpenBlob(blob, Globalx[ e.data.part ].item_name); 
	    } else {
		dl.download = Globalx[ e.data.part ].item_name
		dl.href = window.URL.createObjectURL(blob);
	    }
	})
    }
    else{
	e.preventDefault()
	dl.href = ""
	dl.download = ""
    }
}

function download_cmd(part) {
    if( Globalx[part].key_indicate_file === true ){
	let dl = $( Globalx[part].download_sel )
	dl.trigger('click')
    }
}

