class SideMenu {
    constructor (num , part){
	this.part = part
	this.num = num
	this.menu_sel = Globalx[part].menu_sel
	this.menu_id = Globalx[part].menu_id
	this.textarea_sel = Globalx[part].textarea_sel
	this.bookmark_op_sel = Globalx[part].bookmark_op_sel
    }
    set_editor( editor ){
	this.editor = editor /* Globalx[part].editor */
    }

    async setup(top_sel){
	console.log("SideMenu setup menu_sel=" + this.menu_sel)
	let content = `<ul id="${this.menu_id}"></ul>`
	$(top_sel).append( content )
	this.get_filelist_async( this.num , this.part , (text) => {
	    console.log("SideMenu setup text=" + text)
	    let str = text
	    let obj
	    if( str.match( /{.*}/ ) === null ){
		obj = {}
		console.log("sidemenu setup 1 num=" + this.num + " part=" + this.part)
	    }
	    else {
		obj = JSON.parse( str )
		console.log("sidemenu setup 2 num=" + this.num + " part=" + this.part + " str="+str)
	    }
	    console.log( "sidemenu setup this.num=" + this.num + " this.part=" + this.part )
	    Globalx.storagex.change_cache( obj, this.num , this.part )
	    
	    this.make_menu_item_list( obj , Globalx[this.part].key)
	    $( this.menu_sel ).menu({
		classes: {
		    "ui-menu": "highlight"
		}
	    })
	})
    }

    async get_filelist_async( num , part , func){
	if( part == "setting" ){
	    console.log( "get_filelist_async START part="+ part)
	}
	let realData = Globalx.storagex.get_filelist( num , part )

	if( part == "setting" ){
	    console.log( "get_filelist_async 2 part=" + part)
	}
	if( realData === undefined || realData === null ){
	    if( part == "setting" ){
		console.log( "get_filelist_async 3 part=" + part)
	    }
	    await Globalx.remotex.get_filelist_from_remote( num, part, func )
	    if( part == "setting" ){
		console.log( "get_filelist_async 4 part=" + part)
	    }
	}
	else{
	    const obj = Globalx.storagex.get_filelist( num , part )
	    this.make_menu_item_list( obj , Globalx[this.part].key)
	    $( this.menu_sel ).menu({
		classes: {
		    "ui-menu": "highlight"
		}
	    })
	}
    }

    menu_action( item_name , up_flag = false ) {
	if( Globalx[this.part].key != '/' ){
	    
	}
	let part = this.part
	let jsondata = Globalx.storagex.get_filelist( Globalx.num , part)

	Globalx[part].key_indicate_file = false;
	if( up_flag ){
	    this.set_globalx_item_name(part, "")
	    Globalx[part].editor.getSession().setValue( "" );
	    $( this.textarea_sel ).val( "" );
	    if( Globalx[part].key != '/' ){
		let array = Globalx[part].key.split("/")
		array.pop()
		if( array.length > 1 ){
		    Globalx[part].key_type = false;
		    this.set_globalx_item_name( part, array[array.length - 1] )

		    Globalx[part].key = array.join('/')
		    $( Globalx[part].menu_sel ).empty()
		}
		else {
		    Globalx[part].key = '/'
		    this.set_globalx_item_name( part, "" )
		}
	    }
	}
	else{
	    if( Globalx[part].key == '/' ){
		Globalx[part].key = Globalx[part].key + item_name
	    }
	    else{
		Globalx[part].key = Globalx[part].key + '/' + item_name
	    }
	}
	this.set_globalx_item_name(part, item_name)

	const bookmark_cb = $( this.bookmark_op_sel )
	if( Globalx[part].bookmarks.indexOf( Globalx[part].key ) >= 0 ){
	    bookmark_cb.prop('checked', true)
	}
	else{
	    bookmark_cb.prop('checked', false)
	}

	$( Globalx[part].key_sel ).val( Globalx[part].key )

	$( this.menu_sel ).empty()

	this.make_menu_item_list(jsondata, Globalx[part].key)

	if( jsondata !== undefined && jsondata[Globalx[part].key] !== undefined ){
	    if( jsondata[Globalx[part].key].length == 0 ){
		Globalx[part].key_indicate_file = true;
		Globalx.remotex.get_content( this.num, this.part, Globalx[part].key , (content) => {
		    //console.log("content=" + content)
		    Globalx[part].editor.getSession().setValue( content );
		    $( Globalx[part].textarea_sel ).val( content );
		});
	    }
	}
    }

    make_menu_item_list( realData , key){
	let content = null
	let ary = realData[ key ]
	
	let name = '..(Up)'
	content = `<li class="ui-menu-item"><div class="ui-menu-item-wrapper hasmenu" onclick="menu_action( '${this.part}', '${this.name}', true)">${name}</div></li>`;
	//	content = `<li class="ui-menu-item"><div class="ui-menu-item-wrapper hasmenu" onclick="this.menu_action_2">${name}</div></li>`;
	$( this.menu_sel ).append(content);

	if( ary !== undefined ){
	    ary.map( ( item_name ) => {
		content = `<li class="ui-menu-item"><div class="ui-menu-item-wrapper hasmenu" onclick="menu_action( '${this.part}', '${item_name}' , false)">${item_name}</div></li>`;
		//	    content = `<li class="ui-menu-item"><div class="ui-menu-item-wrapper hasmenu" onclick="this.menu_action_2">${item_name}</div></li>`;
		$( this.menu_sel ).append(content);
	    })
	}
    }

    set_globalx_item_name( item_name ) {
	Globalx[this.part].item_name = item_name
	let dl = $( '#download' )
	dl.attr('download' , Globalx[this.part].item_name)
	dl.removeAttr('href')
    }

    contextmenux0( menu_sel ) {
	$( menu_sel ).contextmenu({
	    delegate: ".hasmenu",
	    menu: [
		{title: "Copy", cmd: "copy", uiIcon: "ui-icon-copy"},
		{title: "----"},
		{title: "More", childern: [
		    {title: "Sub 1", cmd: "sub1"},
		    {title: "Sub 2", cmd: "sub1"}
		]}
	    ],
	    select: (event, ui) => {
		alert("select " + ui.cmd + " on " + ui.target.text());
	    }
	});
    }
}
