<?php

namespace ns;

class PathInfo {
    protected $root;
    public $hier_hash;
    protected $root_path;

    function __construct( $root_path ){
        $this->root_path = $root_path;
        $this->root = new PathItem( "/" , "/");
        $this->hier_hash = array();
        $this->hier_hash["/"] = $this->root;
    }

    public function register( $path ){
        $path2 = trim($path);
        if( strlen($path2) == 0 ){
            echo "size is 0 - A\n";
            exit(0);
        }
        if( array_key_exists($path2,  $this->hier_hash)){
            return;
        }
        $array = explode("/", $path2);
        $name = array_pop($array);
        $item = new PathItem( $name, $path2 , $path2 );
        $this->hier_hash[$path2] = $item;

        $child_item = $item;

        $dosenot_exist = TRUE;
        while( count($array) > 0 && $dosenot_exist ){
            $hier = implode("/" , $array);
            if( strlen($hier) == 0 ){
                break;
            }
            if (array_key_exists($hier,  $this->hier_hash)){
                $item = $this->hier_hash[$hier];
                $dosenot_exist = FALSE;
            }
            else {
                $name = array_pop($array);
                $item = new PathItem( $name, $hier);
                $this->hier_hash[$hier] = $item;
            }

            $child_item->set_parent($item);
            $child_item = $item;
        }
        if( $dosenot_exist ){
            $child_item->set_parent($this->root);
        }
    }

    public function get_pathitem_name( $item ){
        return $item->get_name();
    }

    public function pathinfo_list_in_json(){
        $array = array();
        foreach( $this->hier_hash as $a => $b ){
            $names = array_map(array($this, 'get_pathitem_name'), $b->get_children());
            $array[$a]=$names;
        }
        return json_encode($array);
    }

    public function dump() {
        #       var_dump($this->hier_hash);
        foreach( $this->hier_hash as $a => $b ){
            echo "###########\n";
            echo "key=" . $a . "\n";
            echo $b->dump();
            echo $b->dump_children();
        }
    }

    public function dump_root(){
        $this->root->dump_children();
    }
}

?>
