function contextmenux2( menu_sel ) {
	$(menu_sel).contextmenu({
		delegate: ".hasmenu",
		hide: { effect: "explode", duration: "slow" },
		menu: "#options",
//        position: {my: "left top", at: "left bottom"},
		position: function(event, ui){
			return {my: "left top", at: "left bottom", of: ui.target};
		},
		preventSelect: true,
		show: { effect: "fold", duration: "slow"},
		taphold: true,
		uiMenuOptions: { // Additional options, used when UI Menu is created
			position: { my: "left top", at: "right+10 top+10" }
		},
		focus: function(event, ui) {
			var menuId = ui.item.find(">a").attr("href");
			$("#info").text("focus " + menuId);
			console.log("focus", ui.item);
		},
		blur: function(event, ui) {
			$("#info").text("");
			console.log("blur", ui.item);
		},
		beforeOpen: function(event, ui) {
//			$("#container").contextmenu("replaceMenu", "#options2");
//			$("#container").contextmenu("replaceMenu", [{title: "aaa"}, {title: "bbb"}]);
		},
		open: function(event, ui) {
//          alert("open on " + ui.target.text());
		},
		select: function(event, ui) {
			alert("select " + ui.cmd + " on " + ui.target.text());
		}
	});
}

function contextmenux( menu_sel ) {
	$(menu_sel).contextmenu({
		delegate: ".hasmenu",
		autoFocus: true,
		preventContextMenuForPopup: true,
		preventSelect: true,
		taphold: true,
		menu: [
			{title: "Menu Header", cmd: "cat1", isHeader: true},
			{title: "Cut <kbd>Ctrl+X</kbd>", cmd: "cut", uiIcon: "ui-icon-scissors"},
			{title: "Copy <kbd>Ctrl+C</kbd>", cmd: "copy", uiIcon: "ui-icon-copy"},
			{title: "Paste <kbd>Ctrl+V</kbd>", cmd: "paste", uiIcon: "ui-icon-clipboard", disabled: true },
			{title: "----"},
			{title: "More", children: [
				{title: "Sub 1 (callback)", action: function(event, ui) { alert("action callback sub1");} },
				{title: "Sub 2 (dynamic state)", cmd: "sub2", disabled: function(event, ui) {
					return true;
				} },
				{title: "Sub 3 (dynamic hide)", cmd: "sub3", disabled: function(event, ui) {
					return "hide";
				} },
				{title: "Sub 4 (tooltip)", cmd: "sub4", tooltip: "My tooltip"},
				{title: "Sub 5 (dynamic tooltip)", cmd: "sub5", tooltip: function(event, ui) {
					return ui.item.text() + " !!!";
				} },
				{cmd: "sub6", title: function(event, ui) {
					return "Sub 6 (dynamic title): " + ui.target.text();
				} }
				]}
			],
		// Handle menu selection to implement a fake-clipboard
		select: function(event, ui) {
			var $target = ui.target;
			switch(ui.cmd){
			case "copy":
				CLIPBOARD = $target.text();
				break
			case "paste":
				CLIPBOARD = "";
				break
			}
			alert("select " + ui.cmd + " on " + $target.text());
			// Optionally return false, to prevent closing the menu now
		},
		// Implement the beforeOpen callback to dynamically change the entries
		beforeOpen: function(event, ui) {
			var $menu = ui.menu,
				$target = ui.target,
				extraData = ui.extraData; // passed when menu was opened by call to open()

			// console.log("beforeOpen", event, ui, event.originalEvent.type);

			// NOTE: zIndex() was removed in jQuery 1.12:
			// https://jqueryui.com/upgrade-guide/1.12/#removed-zindex
//			ui.menu.zIndex( $(event.target).zIndex() + 1);

			$(document)
//				.contextmenu("replaceMenu", [{title: "aaa"}, {title: "bbb"}])
//				.contextmenu("replaceMenu", "#options2")
//				.contextmenu("updateEntry", "cut", {title: "Cuty", uiIcon: "ui-icon-heart", disabled: true})
				.contextmenu("setTitle", "copy", "Copy '" + $target.text() + "'")
				.contextmenu("setTitle", "paste", "Paste" + (CLIPBOARD ? " '" + CLIPBOARD + "'" : ""))
				.contextmenu("enableEntry", "paste", (CLIPBOARD !== ""));

			// $(document)
			// 	.contextmenu("setIcon", "paste", "ui-icon-heart")
			// 	.contextmenu("setTooltip", "paste", "ui-icon-heart");

			// Optionally return false, to prevent opening the menu now
		}
	});
}
