class BookmarkMgr {
    constructor( max_display_name_length ) {
	this.paths = []
	this.items = {}
	this.max_display_name_length = max_display_name_length
    }

    add( path , display_name = null){
	let result = this.paths.indexOf( path )
	if( result < 0 ){
	    this.paths.push( path )
	    this.items[ path ] = new Bookmark( path , this.max_display_name_length , display_name )
	}
	return this.items[ path ]
    }

    remove( path ){
	let result = this.paths.indexOf( path )
	if( result >= 0 ){
	    delete this.items[ path ]
	    delete this.paths[ result ]
	}
    }

    get( path ){
	let ret = null
	let result = this.paths.indexOf( path )
	if( result >= 0 ){
	    ret = this.items[ path ]
	}
	return ret
    }

    display_name( path ){
	let result = this.paths.indexOf( path )
	let disp = null
	if( result >= 0 ){
	    disp = this.items[ path ].display_name
	}
	return disp
    }

    get_paths(){
	return this.paths
    }

    get_display_names(){
	const array = thils.paths
	return array.map( function( path ){ 
	    return this.items[ path ].display_name
	} )
    }

    get_restricted_display_name( path ){
	return path.substr( -this.max_display_name_length )
    }

    get_items() {
	return this.items
    }

    max_display_name_length(){
	return this.max_display_name_length
    }
}
