class BookmarkMenu {
    constructor(num, part) {
	this.num = num
	this.part = part
	this.bookmark_op_sel = Globalx[part].bookmark_op_sel
	this.bookmark_mgr = Globalx[part].bookmark_mgr
	this.bookmark_sel = Globalx[part].bookmark_sel
	this.key_sel = Globalx[part].key_sel
	this.editor = Globalx[part].editor
	this.textarea_sel = Globalx[part].textarea_sel
	this.menu_sel = Globalx[part].menu_sel
    }

    add_bookmark() {
	$( '#bookmark_displayname' ).val( Globalx[this.part].bookmark_mgr.get_restricted_display_name( Globalx[this.part].key ) )
	$( '#bookmark_path' ).val( Globalx[this.part].key )
	$( '#bookmarkDlg' ).dialog("open")
    }

    remove_bookmark() {
	this.bookmark_mgr.remove( Globalx[this.part].key )
	this.rebuild_bookmark_menu()
    }

    bookmark_op() {
	if( $( this.bookmark_op_sel ).is(':checked') == true ){
	    this.add_bookmark()
	}
	else{
	    this.remove_bookmark()
	}
    }

    set_click_handler() {
	console.log( "set_click_handler() part=" + this.part + " num=" + this.num )
	$( this.bookmark_op_sel ).on( 'click' , () => { this.bookmark_op() } )
    }

    register_bookmark_( path, displayname ) {
	this.bookmark_mgr.add( path , displayname )
	this.rebuild_bookmark_menu()
    }

    rebuild_bookmark_menu() {
	$( this.bookmark_sel ).empty()

	const array = this.bookmark_mgr.get_paths()

	array.map( ( path ) => {
	    const display_name = this.bookmark_mgr.display_name( path )
	    content = `<li><a href="#" onclick="this.bookmark_action( '${this.part}' , '${this.path}' )">${display_name}</a></li>`;
	    $( this.bookmark_sel ).append(content);
	})
    }

    bookmark_action = ( part, key ) => {
	if( key === null || key === "" ){
	    alert("illeagal key=" + key )
	    return
	}
	if(key === Globalx[part].key){
	    return
	}

	let realData = Globalx.remotex.get_filelist( this.num )
	Globalx[part].key = key
	Globalx[part].key_indicate_file = false;

	this.set_globalx_item_name( part, key )
	$( this.key_sel ).val( key )

	if( realData[Globalx[part].key].length == 0 ){
	    Globalx[part].key_indicate_file = true;
	    Globalx.remotex.get_content( this.num, this.part, Globalx[part].key , (content) => {
		this.editor.getSession().setValue( content );
		$( this.textarea_sel ).val( content );
	    });
	}
	else{
	    Globalx[part].key_indicate_file = false
	    this.editor.getSession().setValue( "" );
	    $( this.textarea_sel ).val( "" );
	}
	const bookmark_cb = $( this.bookmark_op_sel )
	bookmark_cb.prop('checked', true)

	$( this.menu_sel ).empty()

	this.rebuild_bookmark_menu()
	// this.make_menu_item_list(realData, Globalx[part].key)
    }
}
