let Globalx = {};
const GlobalxItems = ["output_url"]
const GlobalxInitValue = {
    editor: null,
    key_indicate_file: false,
    key: '/'
};
const GlobalxInitValueItems = ["editor", "key_indicate_file", "key"]

function init_globalx_storagex() {
    Globalx.storagex = new Storagex();
    Globalx.build = {
	'contest2011.md': {
	    path: '/attempt/contest2011/data/contest2011.md',
	    target: 'cont',
	    subtarget: '2011',
	    category: 'attempt',
	    output_html: 'contest2011.html',
	    alias_html: 'contest.html',
	}
    }

}


function init_globalx() {
    Globalx.num = 0
    Globalx.index = 0
    Globalx.parts = ["data" , "output", "conf"]
    Globalx.bookmark_displayname_max_length = 18
    Globalx.output_url = null
    Globalx.output_url_listx = null
    Globalx.remote_filename = 'php/content3.php'
    Globalx.build = new Build()

    tab_init()
    topmenu_init()
    Globalx.remotex = new Remotex( Globalx.remote_filename )
    if( Globalx.bookmark_mgr === null || Globalx.bookmark_mgr === undefined ){
	Globalx.bookmark_mgr = new BookmarkMgr(Globalx.bookmark_displayname_max_length, Globalx.parts)
    }
    Globalx.bookmarkmenu = null

    Globalx.build.setup('data')
}

function set_output_url_listx(text){
    if( text.match( /{.*}/ ) !== null ){
	const obj = JSON.parse( text )
	//console.log("update_all_info_on_host text=" + text )
	Globalx.output_url_listx = {}
	obj["htmlfname"].forEach( (item) => {
	    let words = item.full.split('.')
	    let base = words[0]
	    Globalx.output_url_listx[ base ] = {}
	    Globalx.output_url_listx[ base ].full = `${obj["output_url"]}/${item.full}`
	    Globalx.output_url_listx[ base ].partial = `${obj["output_url"]}/${item.partial}`
	    console.log(`${words[0].full}=${ Globalx.output_url_listx[ base ].full }`)
	    console.log(`${words[0].partial}=${ Globalx.output_url_listx[ base ].partial }`)
	} )
	Globalx.storagex.save_as_info_from_globalx()
    }
}

async function update_all_info_on_host_async( ) {
    await Globalx.remotex.update_output_url_listx( Globalx.num , (text) => {
	set_output_url_listx(text)
    } )

    Globalx.parts.map( ( part ) => {
	Globalx[ part ].sidemenu.update(`#${part}-side`)
    } )

}

async function get_output_url( num ){
    get_output_url_async( num, (str) => {
	if( str.match( /{.*}/ ) !== null ){
	    const obj = JSON.parse( str )
//console.log("get_output_url obj=" + obj.output_url)
	    Globalx.output_url = obj.output_url
	    Globalx.storagex.save_as_info_from_globalx()
	}
    } )

}
async function get_output_url_async( num, func ){
    let output_url = Globalx.storagex.get_output_url()

    if( output_url === undefined || output_url === null ){
	await Globalx.remotex.get_output_url( num, func )
    }
    else{
	Globalx.output_url = output_url
	Globalx.storagex.save_as_info_from_globalx()
    }
} 

async function get_output_url_listx_async( num ) {
    await Globalx.remotex.get_output_url_listx( num , (text) => {
	set_output_url_listx(text)
    } )
}

async function setup(){
    await get_output_url_listx_async( Globalx.num )
//    await get_output_url( Globalx.num )
}


function main() {
    init_globalx_storagex()

    let need_to_save = Globalx.storagex.restore_globalx_from_info()
    init_globalx()
    setup()

    Globalx.bookmarkmenu = new BookmarkMenu( Globalx.bookmark_displayname_max_length , Globalx.bookmark_mgr )
    Globalx.bookmarkmenu.dlg()

    Globalx.parts.map( ( part ) => {
	set_globalx_editor(part)

	Globalx[ part ].menu = null
	Globalx[ part ].sidemenu = new SideMenu( Globalx.num, part )
	Globalx[ part ].sidemenu.setup(`#${part}-side`)

	$( Globalx[ part ].download_sel ).on('click', {num: Globalx.num, part: part}, handleDownload)
	$( Globalx[ part ].textarea_sel ).val("");
	Globalx.bookmarkmenu.rebuild_bookmark_menu(part)
	Globalx.bookmarkmenu.set_click_handler(part)
    } )

    if( need_to_save ){
	// LocalStorageにまだ保存していない場合、ここで保存しておく
	Globalx.storagex.save_as_info_from_globalx( (data) => { console.log( "data=" + data ) } )
    }
}


function set_globalx_editor(part) {
      Globalx[part] = {
	  editor_id: `${part}-editor`,
	  editor: null, /* variable */
	  textarea_sel: `textarea[name=${part}-editor-t`,
/**/
	  menu_id: `${part}-menu2`,
          bookmark_id: `${part}-bookmark`,
          bookmark_op_id: `${part}-bookmark_op`,
          item_name: "",
/**/
	  bookmarks: [], 
          key_indicate_file: false, /* variable */
	  key: '/', 
	  key_sel: `#${part}-filelist_key`,
          download_sel: `#${part}-down-download`,
          download_url_sel: `#${part}-down-url`,
          download_partial_url_sel: `#${part}-partial-down-url`
      }
      editor_config(part);

      Globalx[part].menu_sel = `#${Globalx[part].menu_id}`
      Globalx[part].bookmark_sel = `#${Globalx[part].bookmark_id}`
      Globalx[part].bookmark_op_sel = `#${Globalx[part].bookmark_op_id}`
}

function editor_config(part) {
      let editor = ace.edit( Globalx[part].editor_id )
      editor.setTheme("ace/theme/monokai");
      editor.setFontSize(14);
      editor.getSession().setMode("ace/mode/markdown");
      editor.getSession().setUseWrapMode(true);
      editor.getSession().setTabSize(2);
      Globalx[part].editor = editor;

      let textarea = $( Globalx[part].textarea_sel )
      editor.getSession().on("change", () => {
/*          textarea.val(editor.getSession().getValue()) */
	  $( Globalx[part].textarea_sel ).val(editor.getSession().getValue())
      });
}

function upload_to_host( part ){
    Globalx.remotex.upload_to_host( part )
}
