class SideMenu {
    constructor (num , part){
	this.part = part
	this.num = num
	this.menu_sel = Globalx[part].menu_sel
	this.menu_id = Globalx[part].menu_id
	this.textarea_sel = Globalx[part].textarea_sel
	this.bookmark_op_sel = Globalx[part].bookmark_op_sel
	this.full_download_url_sel = `#${part}-down-url`
	this.partial_download_url_sel = `#${part}-partial-down-url`
    }

    set_editor( editor ){
	this.editor = editor /* Globalx[part].editor */
    }

    display_menu( text ) {
	let str = text
	let obj
	if( str.match( /{.*}/ ) === null ){
	    console.log("sidemenu 1 num="+ this.num + " part="+ this.part +" str="+str)
	    obj = {}
	}
	else {
	    console.log("sidemenu 2 num="+ this.num +" part="+ this.part +" str="+str)
	    obj = JSON.parse( str )
	}
	Globalx.storagex.change_cache( obj, this.num , this.part )

	this.setup_menu(obj)
    }

    setup_menu(obj){
	this.make_menu_item_list( obj , Globalx[this.part].key)
	if( Globalx[this.part].menu === null ){
	    Globalx[this.part].menu = $( this.menu_sel ).menu({
		classes: {
		    "ui-menu": "highlight"
		}
	    })
	}
    }

    menu_init( top_sel ){
	$( top_sel ).empty()
	let content = `<ul id="${this.menu_id}"></ul>`
	$( top_sel ).append( content )
    }

    async setup( top_sel ){
	this.menu_init( top_sel )
	this.get_filelist_async( this.num , this.part , (text) => {
	    this.display_menu(text)
	} )
    }

    async update( top_sel ){
	this.menu_init( top_sel )
	await Globalx.remotex.update_filelist( this.num, this.part, (text) => {
	    this.display_menu(text)
	} )
    }

    async get_filelist_async( num , part , func){
	let realData = Globalx.storagex.get_filelist( num , part )

	if( realData === undefined || realData === null ){
	    await Globalx.remotex.get_filelist_from_remote( num, part, func )
	}
	else{
	    const obj = Globalx.storagex.get_filelist( num , part )
	    this.setup_menu( obj )
	}
    }

    menu_action( item_name , up_flag = false ) {
	let part = this.part
	let jsondata = Globalx.storagex.get_filelist( Globalx.num , part)

	Globalx[part].key_indicate_file = false;
	if( up_flag ){
	    this.set_globalx_item_name(part, "")
	    Globalx[part].editor.getSession().setValue( "" );

	    let words = Globalx[part].item_name.split('.')
	    let base = words[0]
	    $( this.textarea_sel ).val( "" );
	    this.set_anchor_url( part, base, "", "" , "full")
	    this.set_anchor_url( part, base, "", "" , "partial")

	    if( Globalx[part].key != '/' ){
		let array = Globalx[part].key.split("/")
		array.pop()
		if( array.length > 1 ){
		    Globalx[part].key_type = false;
		    this.set_globalx_item_name( part, array[array.length - 1] )

		    Globalx[part].key = array.join('/')
		    $( Globalx[part].menu_sel ).empty()
		}
		else {
		    Globalx[part].key = '/'
		    this.set_globalx_item_name( part, "" )
		}
	    }
	}
	else{
	    if( Globalx[part].key == '/' ){
		Globalx[part].key = Globalx[part].key + item_name
	    }
	    else{
		Globalx[part].key = Globalx[part].key + '/' + item_name
	    }
	}
	this.set_globalx_item_name(part, item_name)

	const bookmark_cb = $( this.bookmark_op_sel )
	if( Globalx[part].bookmarks.indexOf( Globalx[part].key ) >= 0 ){
	    bookmark_cb.prop('checked', true)
	}
	else{
	    bookmark_cb.prop('checked', false)
	}

	$( Globalx[part].key_sel ).val( Globalx[part].key )

	$( this.menu_sel ).empty()

	this.make_menu_item_list(jsondata, Globalx[part].key)

	if( jsondata !== undefined && jsondata[Globalx[part].key] !== undefined ){
	    let words = item_name.split('.')
	    let base = words[0]
	    if( jsondata[Globalx[part].key].length == 0 ){
		Globalx[part].key_indicate_file = true;
		let url = Globalx.output_url_listx[base].full

		$( Globalx[part].download_url_sel ).val( Globalx[part].key )
		$( Globalx[part].download_url_sel ).attr('href' , url )
		$( Globalx[part].download_partial_url_sel ).val( Globalx[part].key + "(parial)" )
		url = url + ".tmp"
		$( Globalx[part].download_partial_url_sel ).attr('href' , url )
		Globalx.remotex.get_content( this.num, this.part, Globalx[part].key , (content) => {
		    Globalx[part].editor.getSession().setValue( content );
		    $( Globalx[part].textarea_sel ).val( content );
		});

		this.set_anchor_down_url( base, Globalx.output_url_listx[base].full, item_name , "full" )
		this.set_anchor_down_url( base, Globalx.output_url_listx[base].partial, item_name , "partial" )
	    }
	    else{
		this.set_anchor_url( part, base, "", "" , "full")
		this.set_anchor_url( part, base, "", "" , "partial")
	    }
	}
    }

    make_menu_item_list( obj , key){
	let content = null
	let item = null
	let ary = obj[ key ]
	
	let name = '..(Up)'
	content = `<li class="ui-menu-item"><div class="ui-menu-item-wrapper hasmenu">${name}</div></li>`;
	$( this.menu_sel ).append(content);
	item = $( this.menu_sel ).children().last()
	item.on('click' , () => {
	    this.menu_action( key , true )
	} )

	if( ary !== undefined ){
	    ary.map( ( item_name ) => {
		content = `<li class="ui-menu-item"><div class="ui-menu-item-wrapper hasmenu">${item_name}</div></li>`;
		$( this.menu_sel ).append(content);
		item = $( this.menu_sel ).children().last()
		item.on('click' , () => {
		    this.menu_action( item_name )
		} )
	    })
	}
    }

    set_globalx_item_name( part , item_name ) {
	Globalx[part].item_name = item_name
	let dl = $( Globalx[ part ].download_sel )
	dl.attr('download' , Globalx[part].item_name)
	dl.removeAttr('href')
    }

    set_anchor_url( part, base, href, text , kind){
	if( href === undefined ){
	    href = ""
	}
	if( text === "" ){
	    Globalx[part].sidemenu.set_anchor_down_url( base, href, text , kind)
	}
	else{
	    let words = text.split('.')
	    let base = words[0]
	    if( Globalx.output_url_listx[base] !==  undefined ){
		Globalx[part].sidemenu.set_anchor_down_url( base, href, text , kind)
	    }
	}
    }

    set_anchor_down_url( base, href, text , kind ){
	let sel = null
	if( href === undefined ){
	    href = ""
	}
	if( href === "" ){
	    text = ""
	}
	if( text !== "" ){
	    if( kind == "full" ){
		Globalx.output_url_listx[base].full = href
	    }
	    else{
		Globalx.output_url_listx[base].partial = href
	    }
	}
	if( kind === "full" ){
	    sel = this.full_download_url_sel
	    if( text !== "" ){
		text = "Full HTML:" + text
	    }
	}
	else{
	    sel = this.partial_download_url_sel
	    if( text !== "" ){
		text = "Partial HTML:" + text
	    }
	}

	$( sel ).attr( "href" , href )
	$( sel ).text( text )
    }

    contextmenux0( menu_sel ) {
	$( menu_sel ).contextmenu({
	    delegate: ".hasmenu",
	    menu: [
		{title: "Copy", cmd: "copy", uiIcon: "ui-icon-copy"},
		{title: "----"},
		{title: "More", childern: [
		    {title: "Sub 1", cmd: "sub1"},
		    {title: "Sub 2", cmd: "sub1"}
		]}
	    ],
	    select: (event, ui) => {
		alert("select " + ui.cmd + " on " + ui.target.text());
	    }
	});
    }
}

