//"php/content.php"
class Remotex {
    constructor( filename ){
	this.filename = filename
	//	this.num = num
	//	this.part = part
    }

    make_url_params( arrayx ){
	let params = new URLSearchParams();
	arrayx.reduce(function(acc, element, index, array) {
	    acc.append(element[0], element[1]);
	    return acc;
	}, params)
	return params;
    }

    async get_filelist_from_remote( num, part, func ) {
	console.log("remotex get_filelist_from_remote num=" + num + " part=" + part )
	let param_array = [['cmd', 'get_filelistx'], ['num', num ], ['part', part ]]
	await this.fetchx( this.filename , param_array, func )
    }

    async update_filelist( num, part, func ) {
	console.log("remotex update_filelist num=" + num + " part=" + part )
	let param_array = [['cmd', 'update_filelistx'], ['num', num ], ['part', part ]]
	await this.fetchx( this.filename , param_array, func )
    }

    async get_content(num, part, path , func) {
	console.log("remotex get_content num=" + num + " part=" + part )
	console.log("part=" + part)
	let param_array = [['cmd', 'get_content'], ['num', num ], ['part', part ], ['path', path]]
	await this.fetchx( this.filename , param_array, func )
    }

    async get_output_url(num, func) {
console.log("get_output_url")
	console.log("remotex get_output_url num=" + num )
	let param_array = [['cmd', 'get_output_url'], ['num', num ] ]
	await this.fetchx( this.filename , param_array, func )
    }

    async fetchx( filename, param_array, func) {
console.log("fetchx func" + func)
	let params = this.make_url_params( param_array )
	fetch(`${filename}?${params}`)
	    .then((response) => response.text())
	    .then((text) => { console.log(func) ; if( func !== undefined ){func(text)} else { console.log("func=undefined")} })
	    .catch((error) => console.log(error));
    }

    upload_to_host(part) {
	if( Globalx[part].key_indicate_file === true ){
	    let textarea = $( Globalx[part].textarea_sel )
	    upload_content(Globalx.num, part, Globalx[part].key, textarea.val())
	}
    }

    upload_content(num, part, path, content) {
	let form = document.createElement('form');
	let req_content = document.createElement('input');
	let req_path = document.createElement('input');
	let req_cmd = document.createElement('input');
	let req_num = document.createElement('input');

	document.body.appendChild(form);
	req_content.type = 'hidden';
	req_content.name = 'mytext';
	req_content.value = content;
	
	req_path.type = 'hidden';
	req_path.name = 'path';
	req_path.value = path;
	
	req_cmd.type = 'hidden';
	req_cmd.name = 'cmd';
	req_cmd.value = 'upload_content';
	
	req_num.type = 'hidden';
	req_num.name = 'num';
	req_num.value = num + '';
	
	form.appendChild(req_content);
	form.appendChild(req_path);
	form.appendChild(req_cmd);
	form.appendChild(req_num);
	
	// FormDataオブジェクトを作成する
	var form_data = new FormData(form);

	fetch('php/content.php', {
	    method: 'POST',
	    mode: 'same-origin', /* 'no-cors' 'cors' 'same-origin' */
	    body: form_data
	})
	    .then((response) => response.text())
	    .then((data) => console.log(data))
	    .catch((error) => console.log(error));
    }

    handleDownload(e) {
	let dl = document.getElementById(`${e.data.part}-down-download`)

	if( Globalx[ e.data.part ].key_indicate_file === true ){
	    this.get_content( e.data.num, e.data.part , Globalx[ e.data.part ].key , (content) => {
		let blob = new Blob([ content ], { "type" : "text/plain" });

		if (window.navigator.msSaveBlob) { 
		    window.navigator.msSaveBlob(blob, Globalx[ e.data.part ].item_name); 
		    
		    // msSaveOrOpenBlobの場合はファイルを保存せずに開ける
		    window.navigator.msSaveOrOpenBlob(blob, Globalx[ e.data.part ].item_name); 
		} else {
		    dl.download = Globalx[ e.data.part ].item_name
		    dl.href = window.URL.createObjectURL(blob);
		}
	    })
	}
	else{
	    e.preventDefault()
	    dl.href = ""
	    dl.download = ""
	}
    }
}

function handleDownload(e) {
    Globalx.remotex.handleDownload(e)
}
