<?php

namespace ns;

class PathInfo {
    protected $root;
    public $hier_hash;
    protected $root_path;

    function __construct( $part, $root_path , $restrict = null){
        $this->part = $part;
        $this->root_path = $root_path;
        $this->root = new PathItem( "/" , "/");
        $this->hier_hash = array();
        $this->hier_hash["/"] = $this->root;
        $this->restrict = null;
        $this->restrict_dir = array();
        if( $restrict !== null ){
            $this->restrict = array();
            foreach($restrict as $k => $v){
                 $pathinfo = pathinfo($v);
                 array_push( $this->restrict,  $pathinfo['filename'] );
            }
        }
    }

    public function match_in_list0( $path2, $list ){
        $hit = false;

        foreach( $list as $k => $r ){
            if( preg_match($r , $path2) ){
                $hit = true;
                break;
            }
        }
        return $hit;
    }

    public function match_in_list( $path, $list ){
        $hit = false;

        $pathinfo = pathinfo($path);
        $index = array_search( $pathinfo['dirname'] , $list );
        if( $index !== FALSE ){
            $hit = true;
        }
        return $hit;
    }

    public function scan( $path ){
        $pathinfo = pathinfo( $path );

        $filename = $pathinfo['filename'];
#        echo "filename=" . $filename . "\n";
#        $basename = $pathinfo['basename'];
#        echo "basename=" . $basename . "\n";

        if( $this->restrict !== null ){
            $index = array_search( $filename , $this->restrict );
            if( $index !== FALSE ){
                $dirname  = $pathinfo['dirname'];
                $this->restrict_dir[ $dirname ] = "";
            }
        }
    }

    public function show_restrict() {
        var_dump( $this->restrict );
    }

    public function show_restrict_dir() {
        var_dump( $this->restrict_dir );
    }

    public function register( $path ){
        $path2 = trim($path);

        if( strlen($path2) == 0 ){
            echo "size is 0 - A\n";
            exit(0);
        }

        if( array_key_exists($path2,  $this->hier_hash)){
            echo "register" . "\n";
            return;
        }

        if( $this->restrict !== null ){
#   echo "match_in_list\n";
            if( ! $this->match_in_list( $path2, array_keys( $this->restrict_dir ) ) ){
#                echo "!match path2=" . $path2 . "\n";
                return;
            }
        }
#        echo "path2=" . $path2 . "\n";
        
        $array = explode("/", $path2);
        $name = array_pop($array);
        $item = new PathItem( $name, $path2 , $path2 );
        $this->hier_hash[$path2] = $item;

        $child_item = $item;

        $dosenot_exist = TRUE;
        while( count($array) > 0 && $dosenot_exist ){
            $hier = implode("/" , $array);
            if( strlen($hier) == 0 ){
                break;
            }
            if (array_key_exists($hier,  $this->hier_hash)){
                $item = $this->hier_hash[$hier];
                $dosenot_exist = FALSE;
            }
            else {
                $name = array_pop($array);
                $item = new PathItem( $name, $hier);
                $this->hier_hash[$hier] = $item;
            }

            $child_item->set_parent($item);
            $child_item = $item;
        }
        if( $dosenot_exist ){
            $child_item->set_parent($this->root);
        }
    }

    public function get_pathitem_name( $item ){
        return $item->get_name();
    }

    public function pathinfo_list_in_json(){
        $array = array();
        $keys = array_keys( $this->hier_hash );
        sort( $keys , SORT_STRING );
        foreach( $keys as $key ){
            $b = $this->hier_hash[ $key ];
            $names = array_map(array($this, 'get_pathitem_name'), $b->get_children());
            sort($names, SORT_STRING);
            $array[$key]=$names;
        } 
        return json_encode($array);
    }

    public function dump() {
        foreach( $this->hier_hash as $a => $b ){
            echo "###########\n";
            echo "key=" . $a . "\n";
            echo $b->dump();
            echo $b->dump_children();
        }
    }

    public function dump_root(){
        $this->root->dump_children();
    }
}

?>
