//"php/content.php"
class Remotex {
    constructor( filename ){
	this.filename = filename
	//	this.num = num
	//	this.part = part
    }

    make_url_params( arrayx , num ){
	let params = new URLSearchParams();
	for(let i=0; i<num; i++ ){
	    params.append(arrayx[i][0], arrayx[i][1])
	}
	const pa = params.toString()
	return pa
    }

    async get_filelist_from_remote( num, part, func ) {
	let param_array = [['cmd', 'get_filelistx'], ['num', num ], ['part', part ]]
	await this.fetchx( this.filename , param_array, 3, func )
    }

    async update_filelist( num, part, func ) {
	let param_array = [['cmd', 'update_filelistx'], ['num', num ], ['part', part ]]
	await this.fetchx( this.filename , param_array, 3, func )
    }

    async get_content(num, part, path , func) {
	let param_array = [['cmd', 'get_content'], ['num', num ], ['part', part ], ['path', path]]
	await this.fetchx( this.filename , param_array, 4, func )
    }

    async get_output_url(num, func) {
	let param_array = [['cmd', 'get_output_url'], ['num', num ] ]
	await this.fetchx( this.filename , param_array, 2, func )
    }

    async get_output_url_listx( num, func) {
	let param_array = [['cmd', 'get_output_url_listx'] , ['num', num]]
	await this.fetchx( this.filename , param_array, 2, func )
    }

    async fetchx( filename, param_array, num, func) {
	let params = this.make_url_params( param_array , num )
	fetch(`${filename}?${params}`)
	    .then((response) => { return response.text() })
	    .then((text) => { func(text) })
	    .catch((error) => console.log("error=" + error));
    }

    upload_to_host(part) {
	if( Globalx[part].key_indicate_file === true ){
	    let textarea = $( Globalx[part].textarea_sel )
	    this.upload_content(Globalx.num, part, Globalx[part].key, textarea.val())
	}
    }

    async build( cmd, num, part, path, content, func = null ) {
	await this.upload_file( cmd, num, part, path, content, func = null )
    }

    async upload_file(cmd, num, part, path, content, func = null) {
	let form = document.createElement('form')
	let req_cmd = document.createElement('input')
	let req_num = document.createElement('input')
	let req_part = document.createElement('input')
	let req_path = document.createElement('input')
	let req_content = document.createElement('input')

	document.body.appendChild(form)

	req_cmd.type = 'hidden'
	req_cmd.name = 'cmd'
	req_cmd.value = cmd
	
	req_num.type = 'hidden'
	req_num.name = 'num'
	req_num.value = num + ''
	
	req_part.type = 'hidden'
	req_part.name = 'part'
	req_part.value = part
	
	req_path.type = 'hidden'
	req_path.name = 'path'
	req_path.value = path
	
	req_content.type = 'hidden'
	req_content.name = 'mytext'
	req_content.value = content
	
	form.appendChild(req_cmd)
	form.appendChild(req_num)
	form.appendChild(req_part)
	form.appendChild(req_path)
	form.appendChild(req_content)
	
	// FormDataオブジェクトを作成する
	var form_data = new FormData(form);
console.log("remotex.js filename=" + this.filename )
	fetch( this.filename , {
	    method: 'POST',
	    mode: 'same-origin', /* 'no-cors' 'cors' 'same-origin' */
	    body: form_data
	})
	    .then((response) => {
		return response.text()
	    })
	    .then((data) => {console.log( "data=" + data)
			     if( func !== null ){
				 func(data)
			     }
			    })
	    .catch((error) => {console.log("error=" + error)})
    }

    upload_content(num, part, path, content) {
	let form = document.createElement('form');
	let req_content = document.createElement('input');
	let req_path = document.createElement('input');
	let req_cmd = document.createElement('input');
	let req_num = document.createElement('input');
	let req_part = document.createElement('input');

	document.body.appendChild(form);
	req_content.type = 'hidden';
	req_content.name = 'mytext';
	req_content.value = content;
	
	req_path.type = 'hidden';
	req_path.name = 'path';
	req_path.value = path;
	
	req_cmd.type = 'hidden';
	req_cmd.name = 'cmd';
	req_cmd.value = 'upload_content';
	
	req_num.type = 'hidden';
	req_num.name = 'num';
	req_num.value = num + '';
	
	req_part.type = 'hidden';
	req_part.name = 'part';
	req_part.value = part;
	
	form.appendChild(req_content);
	form.appendChild(req_path);
	form.appendChild(req_cmd);
	form.appendChild(req_num);
	form.appendChild(req_part);
	
	// FormDataオブジェクトを作成する
	var form_data = new FormData(form);
console.log("remotex.js filename=" + this.filename )
	fetch( this.filename , {
	    method: 'POST',
	    mode: 'same-origin', /* 'no-cors' 'cors' 'same-origin' */
	    body: form_data
	})
	    .then((response) => { return response.text()})
	    .then((data) => {console.log( "data=" + data)})
	    .catch((error) => {console.log("error=" + error)});
    }

    handleDownload(e) {
	let dl = document.getElementById(`${e.data.part}-down-download`)

	if( Globalx[ e.data.part ].key_indicate_file === true ){
	    this.get_content( e.data.num, e.data.part , Globalx[ e.data.part ].key , (content) => {
		let blob = new Blob([ content ], { "type" : "text/plain" });

		if (window.navigator.msSaveBlob) { 
		    window.navigator.msSaveBlob(blob, Globalx[ e.data.part ].item_name); 
		    
		    // msSaveOrOpenBlobの場合はファイルを保存せずに開ける
		    window.navigator.msSaveOrOpenBlob(blob, Globalx[ e.data.part ].item_name); 
		} else {
		    dl.download = Globalx[ e.data.part ].item_name
		    dl.href = window.URL.createObjectURL(blob);
		}
	    })
	}
	else{
	    e.preventDefault()
	    dl.href = ""
	    dl.download = ""
	}
    }
}

function handleDownload(e) {
    Globalx.remotex.handleDownload(e)
}
