class BookmarkMgr {
    constructor( max_display_name_length , parts ) {
	this.paths = {}

	this.parts = parts
	this.parts.map( (part) => {
	    this.paths[part] = []
	} )
	this.items = {}
	this.parts.map( (part) => {
	    this.items[part] = {}
	} )
	this.max_display_name_length = max_display_name_length
    }

    add( part, path , display_name = null){
console.log("BookmarkMgr add part=" + part + " path="+ path)
	let result = this.paths[part].indexOf( path )
	if( result < 0 ){
	    this.paths[part].push( path )
	    this.items[part][ path ] = new Bookmark( path , this.max_display_name_length , display_name )
	}
	return this.items[part][ path ]
    }

    remove( part, path ){
	let result = this.paths[part].indexOf( path )
	if( result >= 0 ){
	    delete this.items[part][ path ]
	    delete this.paths[part][ result ]
	}
    }

    get( part, path ){
	let ret = null
	let result = this.paths[part].indexOf( path )
	if( result >= 0 ){
	    ret = this.items[part][ path ]
	}
	return ret
    }

    display_name( part, path ){
	let result = this.paths[part].indexOf( path )
	let disp = null
	if( result >= 0 ){
	    disp = this.items[part][ path ].display_name
	}
	return disp
    }

    get_paths(part){
	return this.paths[part]
    }

    get_display_names(part, path){
	const array = thils.paths[part]
	return array.map( function( path ){ 
	    return this.items[part][ path ].display_name
	} )
    }

    get_restricted_display_name( path ){
	return path.substr( -(this.max_display_name_length) )
    }

    get_items(part) {
	return this.items[part]
    }

    max_display_name_length(){
	return this.max_display_name_length
    }
}
