let Globalx = {};
const GlobalxItems = ["output_url"]
const GlobalxInitValue = {
    editor: null,
    key_indicate_file: false,
    key: '/'
};
const GlobalxInitValueItems = ["editor", "key_indicate_file", "key"]

function init_globalx_storagex() {
    Globalx.storagex = new Storagex();
}

function init_globalx() {
    Globalx.num = 0
    Globalx.index = 0
    Globalx.parts = ["data", "output", "setting"]
    Globalx.bookmark_displayname_max_length = 18
    Globalx.output_url = null

    tab_init()
    topmenu_init()
    Globalx.remotex = new Remotex('php/content.php')
    console.log( "init_globalx 1 : Globalx.bookmark_mgr="  + Globalx.bookmark_mgr )
    if( Globalx.bookmark_mgr === null || Globalx.bookmark_mgr === undefined ){
	Globalx.bookmark_mgr = new BookmarkMgr(Globalx.bookmark_displayname_max_length, Globalx.parts)
    }
    console.log( "init_globalx 2 : Globalx.bookmark_mgr="  + Globalx.bookmark_mgr )
    Globalx.bookmarkmenu = null
}

async function get_output_url_async( func ){
    let realData = Globalx.storagex.get_output_url()

    if( realData === undefined || realData === null ){
	await Globalx.remotex.get_output_url( func )
    }
    else{
	const obj = Globalx.storagex.get_output_url( num , part )
	Globalx.output_url = obj.output_url
	Globalx.storagex.save_as_info_from_globalx()
    }
} 

async function setup(){
    get_output_url_async( (text) => {
	let str = text
	let obj
	if( str.match( /{.*}/ ) === null ){
	    obj = {}
	}
	else {
	    obj = JSON.parse( str )
	}
	Globalx.storagex.change_cache( obj, this.num , this.part )
    } )
}


function main() {
    init_globalx_storagex()

    let need_to_save = Globalx.storagex.restore_globalx_from_info()
    init_globalx()
    setup()

    console.log("##### Globalx.bookmarkmenu=" + Globalx.bookmarkmenu)
    console.log("##### Globalx.bookmark_mgr=" + Globalx.bookmark_mgr)
    Globalx.bookmarkmenu = new BookmarkMenu( Globalx.bookmark_displayname_max_length , Globalx.bookmark_mgr )
    Globalx.bookmarkmenu.dlg()

    Globalx.parts.map( ( part ) => {
	set_globalx_editor(part)

	Globalx[ part ].sidemenu = new SideMenu( Globalx.num, part )
	Globalx[ part ].sidemenu.setup(`#${part}-side`)

	$( Globalx[ part ].download_sel ).on('click', {num: Globalx.num, part: part}, handleDownload)
	$( Globalx[ part ].textarea_sel ).val("");
	Globalx.bookmarkmenu.rebuild_bookmark_menu(part)
	Globalx.bookmarkmenu.set_click_handler(part)
    } )

    if( need_to_save ){
	// LocalStorageにまだ保存していない場合、ここで保存しておく
	//console.log("call save_as_info_from_globalx()")
	Globalx.storagex.save_as_info_from_globalx( (data) => { console.log( "data=" + data ) } )
    }
/*
    Object.keys(Globalx).forEach((key) => {
	console.log(key)
    }) */
}


function set_globalx_editor(part) {
      Globalx[part] = {
	  editor_id: `${part}-editor`,
	  editor: null, /* variable */
	  textarea_sel: `textarea[name=${part}-editor-t`,
/**/
	  menu_id: `${part}-menu2`,
          bookmark_id: `${part}-bookmark`,
          bookmark_op_id: `${part}-bookmark_op`,
          item_name: "",
/**/
	  bookmarks: [], 
          key_indicate_file: false, /* variable */
	  key: '/', 
	  key_sel: `#${part}-filelist_key`,
          download_sel: `#${part}-down-download`,
          download_url_sel: `#${part}-down-url`,
          download_partial_url_sel: `#${part}-partial-down-url`
      }
      editor_config(part);

      Globalx[part].menu_sel = `#${Globalx[part].menu_id}`
      Globalx[part].bookmark_sel = `#${Globalx[part].bookmark_id}`
      Globalx[part].bookmark_op_sel = `#${Globalx[part].bookmark_op_id}`
}

function editor_config(part) {
      let editor = ace.edit( Globalx[part].editor_id )
      editor.setTheme("ace/theme/monokai");
      editor.setFontSize(14);
      editor.getSession().setMode("ace/mode/markdown");
      editor.getSession().setUseWrapMode(true);
      editor.getSession().setTabSize(2);
      Globalx[part].editor = editor;

      let textarea = $( Globalx[part].textarea_sel )
      editor.getSession().on("change", (textarea) => {
          textarea.val(editor.getSession().getValue());
      });
}
